package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安全追溯-起重机械
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgTechParamsLiftingDto", description="安全追溯-起重机械")
public class IdxBizJgTechParamsLiftingDto  extends BaseDto {

   private static final long serialVersionUID = 1L;




    @TableField("RECORD")
    private String record;



    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @TableField("JURISDICTIONAL_AGENCY")
    private String jurisdictionalAgency;

    @TableField("DEVICE_CATEGORY")
    private String deviceCategory;

    @TableField("EQUIPMENT_CLASS")
    private String equipmentClass;

    @TableField("REGISTRATION_NO")
    private String registrationNo;

    @TableField("IDENTIFICATION_CODE")
    private String identificationCode;

    @TableField("DEVICE_CODE")
    private String deviceCode;

    @TableField("SUPERVISORY_CODE")
    private String supervisoryCode;

    @TableField("REGION")
    private String region;

    @TableField("DETAILED_ADDRESS")
    private String detailedAddress;

    @TableField("EQUIPMENT_STATUS")
    private String equipmentStatus;

    @ApiModelProperty(value = "额定起重量")
    @TableField("RATED_LIFTING_CAPACITY")
    private String ratedLiftingCapacity;

    @ApiModelProperty(value = "最大起重量")
    @TableField("MAX_LIFTING_CAPACITY")
    private String maxLiftingCapacity;

    @ApiModelProperty(value = "最大起重力矩")
    @TableField("MAX_LIFTING_TORQUE")
    private String maxLiftingTorque;

    @ApiModelProperty(value = "跨度（工作幅度）")
    @TableField("SPAN_WORKING_RANGE")
    private String spanWorkingRange;

    @ApiModelProperty(value = "起升速度")
    @TableField("LIFTING_SPEED")
    private String liftingSpeed;

    @ApiModelProperty(value = "起升高度")
    @TableField("LIFTING_HEIGHT")
    private String liftingHeight;

    @ApiModelProperty(value = "下降速度")
    @TableField("DESCENT_SPEED")
    private String descentSpeed;

    @ApiModelProperty(value = "变幅高度")
    @TableField("LUFFING_HEIGHT")
    private String luffingHeight;

    @ApiModelProperty(value = "回转速度")
    @TableField("SLEWING_SPEED")
    private String slewingSpeed;

    @ApiModelProperty(value = "高度")
    @TableField("HEIGHT")
    private String height;

    @ApiModelProperty(value = "工作级别")
    @TableField("WORK_LEVEL")
    private String workLevel;

    @ApiModelProperty(value = "额定起重力矩")
    @TableField("RATED_LIFTING_TORQUE")
    private String ratedLiftingTorque;

    @ApiModelProperty(value = "最大起升高度")
    @TableField("MAXI_LIFTING_HEIGHT")
    private String maxiLiftingHeight;

    @ApiModelProperty(value = "最大工作幅度")
    @TableField("MAX_WORK_RANGE")
    private String maxWorkRange;

    @ApiModelProperty(value = "最大工作幅度对应的起重量")
    @TableField("MAX_WOK_RANGE_WEIGHT")
    private String maxWokRangeWeight;

    @ApiModelProperty(value = "最大附着高度")
    @TableField("MAX_ATTACHMENT_HEIGHT")
    private String maxAttachmentHeight;

    @ApiModelProperty(value = "最大计算轮压")
    @TableField("MAX_CALCULATED_PRESSURE")
    private String maxCalculatedPressure;

    @ApiModelProperty(value = "整机设计重量")
    @TableField("MACHINE_DESIGN_WEIGHT")
    private String machineDesignWeight;

    @ApiModelProperty(value = "运行轨距")
    @TableField("RUN_GAUGE")
    private String runGauge;

    @ApiModelProperty(value = "整机功率")
    @TableField("OVERALL_POWER")
    private String overallPower;

    @ApiModelProperty(value = "供电电源")
    @TableField("POWER_SUPPLY")
    private String powerSupply;

    @ApiModelProperty(value = "工作环境温度")
    @TableField("WORK_AMBIENT_TEMPERATURE")
    private String workAmbientTemperature;

    @ApiModelProperty(value = "层数/泊位数")
    @TableField("NUMBER_STOREY")
    private Integer numberStorey;

    @ApiModelProperty(value = "主体结构型式")
    @TableField("MAIN_STRUCTURE_TYPE")
    private String mainStructureType;

    @ApiModelProperty(value = "主要受力结构件材料")
    @TableField("MAIN_STRESSED_STRUCTURAL_MATERIAL")
    private String mainStressedStructuralMaterial;

    @ApiModelProperty(value = "变幅方式")
    @TableField("LUFFING_MODE")
    private String luffingMode;

    @ApiModelProperty(value = "塔身标准节型式")
    @TableField("TOWER_STANDARD_TYPE")
    private String towerStandardType;

    @ApiModelProperty(value = "基座型式")
    @TableField("BASE_TYPE")
    private String baseType;

    @TableField("NAME")
    private String name;

    @TableField("PRODUCT_NUMBER")
    private String productNumber;

    @TableField("MODEL_SPECIFICATION")
    private String modelSpecification;

    @TableField("MANUFACTURER")
    private String manufacturer;

    @TableField("MANUFACTURE_DATE")
    private String manufactureDate;

    @TableField("TYPE_TEST_CERTIFICATE_NUMBER")
    private String typeTestCertificateNumber;

    @ApiModelProperty(value = "大车运行速度")
    @TableField("BIGCAR_RUN_SPEED")
    private String bigcarRunSpeed;

    @ApiModelProperty(value = "小车运行速度")
    @TableField("SMALLCARRUN_SPEED")
    private String smallcarrunSpeed;

    @ApiModelProperty(value = "大车基距")
    @TableField("BIGCAR_BASE_DISTANCE")
    private String bigcarBaseDistance;

    @ApiModelProperty(value = "小车轨距")
    @TableField("SMALLCAR_BASE_DISTANCE")
    private String smallcarBaseDistance;

    @ApiModelProperty(value = "主钩左右极限位置")
    @TableField("MAIN_HOOK_LEFT_AND_RIGHT_LIMIT_POSITIONS")
    private String mainHookLeftAndRightLimitPositions;

    @ApiModelProperty(value = "主梁型式")
    @TableField("MAIN_BEAM_TYPE")
    private String mainBeamType;

    @ApiModelProperty(value = "支腿型式")
    @TableField("OUTRIGGER_TYPE")
    private String outriggerType;

    @ApiModelProperty(value = "最小工作幅度")
    @TableField("MIN_WORK_RANGE")
    private String minWorkRange;

    @ApiModelProperty(value = "最小幅度起重量")
    @TableField("MIN_LIFTING_CAPACITY")
    private String minLiftingCapacity;

    @ApiModelProperty(value = "全程变幅时间")
    @TableField("FULL_RANGE_LUFFING_TIME")
    private String fullRangeLuffingTime;

    @ApiModelProperty(value = "行走机械轨距")
    @TableField("TRAVEL_MACHINE_GAUGE")
    private String travelMachineGauge;

    @ApiModelProperty(value = "行驶速度")
    @TableField("TRAVEL_SPEED")
    private String travelSpeed;

    @ApiModelProperty(value = "支腿调节长度")
    @TableField("LEG_ADJUSTMENT_LENGTH")
    private String legAdjustmentLength;

    @ApiModelProperty(value = "发动机型号/VIN代号/编号")
    @TableField("ENGINE_MODEL")
    private String engineModel;

    @ApiModelProperty(value = "臂架型式")
    @TableField("BOOM_TYPE")
    private String boomType;

    @ApiModelProperty(value = "起升高度(轨上)")
    @TableField("LIFTING_HEIGHT_ON_RAIL")
    private String liftingHeightOnRail;

    @ApiModelProperty(value = "起升高度(轨下)")
    @TableField("LIFTING_HEIGHT_UNDER_RAIL")
    private String liftingHeightUnderRail;

    @ApiModelProperty(value = "整机最大高度")
    @TableField("MACHINE_MAX_HEIGHT")
    private String machineMaxHeight;

    @ApiModelProperty(value = "用途")
    @TableField("USE")
    private String use;

    @ApiModelProperty(value = "臂架结构型式")
    @TableField("BOOM_STRUCTURE_TYPE")
    private String boomStructureType;

    @ApiModelProperty(value = "门架结构型式")
    @TableField("GANTRY_STRUCTURE_TYPE")
    private String gantryStructureType;

    @ApiModelProperty(value = "额定载重量")
    @TableField("RATED_LOAD_CAPACITY")
    private String ratedLoadCapacity;

    @ApiModelProperty(value = "额定成员数")
    @TableField("RATED_MEMBERS")
    private Integer ratedMembers;

    @ApiModelProperty(value = "额定提升速度")
    @TableField("RATED_LIFTING_SPEED")
    private String ratedLiftingSpeed;

    @ApiModelProperty(value = "自由端高度")
    @TableField("HEIGHT_FREE_END")
    private String heightFreeEnd;

    @ApiModelProperty(value = "最大提升高度")
    @TableField("MAXIMUM_LIFTING_HEIGHT")
    private String maximumLiftingHeight;

    @ApiModelProperty(value = "吊笼工作行程")
    @TableField("WORK_STROKE_CAGE")
    private String workStrokeCage;

    @ApiModelProperty(value = "吊笼尺寸(长×宽×高)")
    @TableField("CAGE_SIZE")
    private String cageSize;

    @ApiModelProperty(value = "标准节尺寸(长×宽×高)")
    @TableField("STANDARD_SECTION_SIZE")
    private String standardSectionSize;

    @ApiModelProperty(value = "操纵方式")
    @TableField("CONTROL_MODE")
    private String controlMode;

    @ApiModelProperty(value = "驱动机构型式")
    @TableField("DRIVE_MECHANISM_TYPE")
    private String driveMechanismType;

    @ApiModelProperty(value = "标准节加节方式")
    @TableField("STANDARD_SECTION_ADD_METHOD")
    private String standardSectionAddMethod;

    @ApiModelProperty(value = "存容量")
    @TableField("STORAGE_CAPACITY")
    private Integer storageCapacity;

    @ApiModelProperty(value = "起升驱动方式")
    @TableField("LIFTING_DRIVE_MODE")
    private String liftingDriveMode;

    @ApiModelProperty(value = "适停车辆尺寸 (长×宽×高)")
    @TableField("PARKING_VEHICLE_SIZE")
    private String parkingVehicleSize;

    @ApiModelProperty(value = "额定升降速度")
    @TableField("RATED_LIFT_SPEED")
    private String ratedLiftSpeed;

    @ApiModelProperty(value = "额定横移速度")
    @TableField("RATED_TRAVERSE_SPEED")
    private String ratedTraverseSpeed;

    @ApiModelProperty(value = "额定纵移速度")
    @TableField("RATED_LONGITUDINAL_SPEED")
    private String ratedLongitudinalSpeed;

    @ApiModelProperty(value = "单车最大进(出)车时间")
    @TableField("BICYCLE_MAX_EXIT_TIME")
    private String bicycleMaxExitTime;

    @ApiModelProperty(value = "循环速度")
    @TableField("CYCLE_SPEED")
    private String cycleSpeed;

    @ApiModelProperty(value = "适停车辆质量")
    @TableField("PARKING_VEHICLE_MASS")
    private String parkingVehicleMass;

    @ApiModelProperty(value = "层高")
    @TableField("STOREY_HEIGHT")
    private String storeyHeight;

    @ApiModelProperty(value = "操作方式")
    @TableField("OPERATION_MODE")
    private String operationMode;

    @ApiModelProperty(value = "其 他")
    @TableField("OTHER")
    private String other;

    @ApiModelProperty(value = "起升方式")
    @TableField("LIFTING_MODE")
    private String liftingMode;

    @ApiModelProperty(value = "最大轮压")
    @TableField("MAX_PRESSURE")
    private String maxPressure;

    @ApiModelProperty(value = "下降深度")
    @TableField("DEPTH_DESCENT")
    private String depthDescent;

    @ApiModelProperty(value = "防爆等级")
    @TableField("EXPLOSION_PROOF_GRADE")
    private String explosionProofGrade;

    @ApiModelProperty(value = "防爆型式")
    @TableField("EXPLOSION_PROOF_TYPE")
    private String explosionProofType;

    @ApiModelProperty(value = "吊具型式")
    @TableField("SLING_TYPE")
    private String slingType;

    @ApiModelProperty(value = "主要受力机构件材料")
    @TableField("MAIN_STRESSED_MECHANISM")
    private String mainStressedMechanism;

    @ApiModelProperty(value = "起升机构起升速度倍率")
    @TableField("HOIST_LIFTING_MECHANISM_SPEED")
    private String hoistLiftingMechanismSpeed;

    @ApiModelProperty(value = "起升机构起升速度")
    @TableField("HOIST_LIFTING_SPEED_LIFTING")
    private String hoistLiftingSpeedLifting;

    @ApiModelProperty(value = "起升机构起升速度相应最大起重量")
    @TableField("HOIST_LIFTING_CORRESPONDING_MAX_WEIGHT")
    private String hoistLiftingCorrespondingMaxWeight;

    @ApiModelProperty(value = "起升机构电机型号")
    @TableField("HOIST_MOTOR_MODEL")
    private String hoistMotorModel;

    @ApiModelProperty(value = "起升机构电机数量")
    @TableField("HOIST_MOTORS_NUMBER")
    private Integer hoistMotorsNumber;

    @ApiModelProperty(value = "起升机构功率")
    @TableField("HOIST_POWER")
    private String hoistPower;

    @ApiModelProperty(value = "起升机构制动器型号")
    @TableField("HOIST_BRAKE_MODEL")
    private String hoistBrakeModel;

    @ApiModelProperty(value = "起升机构制动器数量")
    @TableField("HOIST_BRAKES_BRAKES")
    private Integer hoistBrakesBrakes;

    @ApiModelProperty(value = "起升机构工作级别")
    @TableField("HOIST_WORKING_LEVEL")
    private String hoistWorkingLevel;

    @ApiModelProperty(value = "起升机构卷筒直径")
    @TableField("HOIST_DRUM_DIAMETER")
    private String hoistDrumDiameter;

    @ApiModelProperty(value = "起升机构定滑轮直径")
    @TableField("HOIST_FIXED_PULLEY_DIAMETER")
    private String hoistFixedPulleyDiameter;

    @ApiModelProperty(value = "起升机构传动比")
    @TableField("HOIST_TRANSMISSION_RATIO")
    private String hoistTransmissionRatio;

    @ApiModelProperty(value = "起升机构大车轮直径")
    @TableField("HOIST_BIGCAR_DIAMETER")
    private String hoistBigcarDiameter;

    @ApiModelProperty(value = "起升机构小车轮直径")
    @TableField("HOIST_SMALLCAR_DIAMETER")
    private String hoistSmallcarDiameter;

    @ApiModelProperty(value = "大车行走机构速度")
    @TableField("BIGCAR_TRAVE_SPEED")
    private String bigcarTraveSpeed;

    @ApiModelProperty(value = "大车行走机构功率")
    @TableField("BIGCAR_TRAVE_POWER")
    private String bigcarTravePower;

    @ApiModelProperty(value = "大车行走机构工作级别")
    @TableField("BIGCAR_TRAVE_WORKING_LEVEL")
    private String bigcarTraveWorkingLevel;

    @ApiModelProperty(value = "大车行走机构减速器型号")
    @TableField("BIGCAR_TRAVE_REDUCER_MODEL")
    private String bigcarTraveReducerModel;

    @ApiModelProperty(value = "大车行走机构传动比")
    @TableField("BIGCAR_TRAVE_TRANSMISSION_RATIO")
    private String bigcarTraveTransmissionRatio;

    @ApiModelProperty(value = "大车行走机构制动力矩")
    @TableField("BIGCAR_TRAVE_BRAK_TORQUE")
    private String bigcarTraveBrakTorque;

    @ApiModelProperty(value = "大车行走机构大车车轮路面直径")
    @TableField("BIGCAR_TRAVE_ROAD_DIAMETER")
    private String bigcarTraveRoadDiameter;

    @ApiModelProperty(value = "大车行走机构适应轨道")
    @TableField("BIG_TRAVE_ADAPT_TRACK")
    private String bigTraveAdaptTrack;

    @ApiModelProperty(value = "大车行走机构电机型号")
    @TableField("BIGCAR_TRAVE_MOTOR_MODEL")
    private String bigcarTraveMotorModel;

    @ApiModelProperty(value = "大车行走机构电机数量")
    @TableField("BIGCAR_TRAVE_MOTOR_QUANTITY")
    private Integer bigcarTraveMotorQuantity;

    @ApiModelProperty(value = "大车行走机构制动器型号")
    @TableField("BIGCAR_TRAVE_CONTROL_BRAKE_MODEL")
    private String bigcarTraveControlBrakeModel;

    @ApiModelProperty(value = "大车行走机构制动器数量")
    @TableField("BIGCAR_TRAVE_BRAKE_NUMBER")
    private Integer bigcarTraveBrakeNumber;

    @ApiModelProperty(value = "小车行走机构速度")
    @TableField("SMALLCAR_TRAVE_SPEED")
    private String smallcarTraveSpeed;

    @ApiModelProperty(value = "小车行走机构功率")
    @TableField("SMALLCAR_TRAVE_POWER")
    private String smallcarTravePower;

    @ApiModelProperty(value = "小车行走机构转速")
    @TableField("SMALLCAR_TRAVE_REVOLVE_SPEED")
    private String smallcarTraveRevolveSpeed;

    @ApiModelProperty(value = "小车行走机构工作级别")
    @TableField("SMALLCAR_TRAVE_WORKING_LEVEL")
    private String smallcarTraveWorkingLevel;

    @ApiModelProperty(value = "小车行走机构减速器型号")
    @TableField("SMALLCAR_TRAVE_REDUCER_MODEL")
    private String smallcarTraveReducerModel;

    @ApiModelProperty(value = "小车行走机构传动比")
    @TableField("SMALLCAR_TRAVE_TRANSMISSION_RATIO")
    private String smallcarTraveTransmissionRatio;

    @ApiModelProperty(value = "小车行走机构制动力矩")
    @TableField("SMALLCAR_TRAVE_BRAK_TORQUE")
    private String smallcarTraveBrakTorque;

    @ApiModelProperty(value = "小车行走机构小车车轮路面直径")
    @TableField("SMALLCAR_TRAVE_ROAD_DIAMETER")
    private String smallcarTraveRoadDiameter;

    @ApiModelProperty(value = "小车行走机构小车轨道")
    @TableField("SMALLCAR_TRAVE_TROLLEY_TRACK")
    private String smallcarTraveTrolleyTrack;

    @ApiModelProperty(value = "小车行走机构电机型号")
    @TableField("SMALLCAR_TRAVE_MOTOR_MODEL")
    private String smallcarTraveMotorModel;

    @ApiModelProperty(value = "小车行走机构电机数量")
    @TableField("SMALLCAR_TRAVE_MOTOR_QUANTITY")
    private Integer smallcarTraveMotorQuantity;

    @ApiModelProperty(value = "小车行走机构制动器型号")
    @TableField("SMALLCAR_TRAVE_CONTROL_BRAKE_MODEL")
    private String smallcarTraveControlBrakeModel;

    @ApiModelProperty(value = "小车行走机构制动器数量")
    @TableField("SMALLCAR_TRAVE_BRAKE_NUMBER")
    private Integer smallcarTraveBrakeNumber;

    @ApiModelProperty(value = "电源电压")
    @TableField("SUPPLY_VOLTAGE")
    private String supplyVoltage;

    @ApiModelProperty(value = "电源频率")
    @TableField("POWER_FREQUENCY")
    private String powerFrequency;

    @ApiModelProperty(value = "非工作风压")
    @TableField("NO_WORK_WIND_PRESSSURE")
    private String noWorkWindPresssure;

    @ApiModelProperty(value = "工作风压")
    @TableField("WORK_WIND_PRESSSURE")
    private String workWindPresssure;

    @ApiModelProperty(value = "环境温度")
    @TableField("AMBIENT_TEMPERATURE")
    private String ambientTemperature;

    @ApiModelProperty(value = "吊钩部位辐射温度")
    @TableField("RADIATION_TEMPERATURE_OF_HOOK")
    private String radiationTemperatureOfHook;

    @TableField("PART_NAME")
    private String partName;

    @TableField("MAIN_PART_NUMBER")
    private String mainPartNumber;

    @TableField("MAIN_REMARKS")
    private String mainRemarks;

    @TableField("DEVICE_NUMBER")
    private String deviceNumber;

    @TableField("REMARKS_2")
    private String remarks2;

    @ApiModelProperty(value = "梁架跨度")
    @TableField("BEAM_FRAME_SPAN")
    private String beamFrameSpan;

    @ApiModelProperty(value = "桥机跨度")
    @TableField("BRIDGE_CRANE_SPAN")
    private String bridgeCraneSpan;

    @ApiModelProperty(value = "最大架设纵坡")
    @TableField("MAX_ERECTION_LONGITUDINAL_SLOPE")
    private String maxErectionLongitudinalSlope;

    @ApiModelProperty(value = "前支腿调节长度")
    @TableField("ADJUSTABLE_LENGTH_OF_FRONT_OUTRIGGER")
    private String adjustableLengthOfFrontOutrigger;

    @ApiModelProperty(value = "最大架设横坡")
    @TableField("MAX_ERECTION_CROSS_SLOPE")
    private String maxErectionCrossSlope;

    @ApiModelProperty(value = "整机高度")
    @TableField("OVERALL_HEIGHT")
    private String overallHeight;

    @ApiModelProperty(value = "整机宽度")
    @TableField("OVERALL_WIDTH")
    private String overallWidth;

    @ApiModelProperty(value = "整机总功率")
    @TableField("OVERALL_UNIT_POWER")
    private String overallUnitPower;

    @ApiModelProperty(value = "小车纵移速度")
    @TableField("SMALLCAR_LONGITUDINAL_MOVING_SPEED")
    private String smallcarLongitudinalMovingSpeed;

    @ApiModelProperty(value = "过孔速度")
    @TableField("THROUGH_HOLE_VELOCITY")
    private String throughHoleVelocity;

    @ApiModelProperty(value = "整机横移速度")
    @TableField("OVERALL_TRAVERSE_SPEED")
    private String overallTraverseSpeed;

    @ApiModelProperty(value = "小车横移速度")
    @TableField("SMALLCAR_TRAVERSE_SPEED")
    private String smallcarTraverseSpeed;

    @ApiModelProperty(value = "整机长度")
    @TableField("OVERALL_LENGTH")
    private String overallLength;

    @ApiModelProperty(value = "前导梁长度")
    @TableField("LENGTH_OF_FRONT_GUIDE_BEAM")
    private String lengthOfFrontGuideBeam;

    @ApiModelProperty(value = "起升机构减速器型号")
    @TableField("HOIST_REDUCER_MODEL")
    private String hoistReducerModel;

    @ApiModelProperty(value = "大车行走适应轨道")
    @TableField("BIGCAR_TRAVE_ADAPTATION_TRACK")
    private String bigcarTraveAdaptationTrack;

    @ApiModelProperty(value = "大车行走制动器型号")
    @TableField("BIGCAR_TRAVE_BRAKE_MODEL")
    private String bigcarTraveBrakeModel;

    @ApiModelProperty(value = "小车行走机构小车车轮踏面直径")
    @TableField("SMALLCAR_TRAVE_SMALL_TREAD_DIAMETER")
    private String smallcarTraveSmallTreadDiameter;

    @ApiModelProperty(value = "小车行走机构制动器型号")
    @TableField("SMALLCAR_TRAVE_BRAKE_MODEL")
    private String smallcarTraveBrakeModel;

    @ApiModelProperty(value = "小车横移机构速度")
    @TableField("SMALLCAR_SIDESWAY_SPEED")
    private String smallcarSideswaySpeed;

    @ApiModelProperty(value = "小车横移机构功率")
    @TableField("SMALLCAR_SIDESWAY_POWER")
    private String smallcarSideswayPower;

    @ApiModelProperty(value = "小车横移机构转速")
    @TableField("SMALLCAR_SIDESWAY_REVOLVE_SPEED")
    private String smallcarSideswayRevolveSpeed;

    @ApiModelProperty(value = "小车横移机构工作级别")
    @TableField("SMALLCAR_SIDESWAY_WORKING_LEVEL")
    private String smallcarSideswayWorkingLevel;

    @ApiModelProperty(value = "小车横移机构减速器型号")
    @TableField("SMALLCAR_SIDESWAY_REDUCER_MODEL")
    private String smallcarSideswayReducerModel;

    @ApiModelProperty(value = "小车横移机构传动比")
    @TableField("SMALLCAR_SIDESWAY_TRANSMISSION_RATIO")
    private String smallcarSideswayTransmissionRatio;

    @ApiModelProperty(value = "小车横移机构小车横移轨道")
    @TableField("SMALLCAR_SIDESWAY_SMALL_TRAVERSE_TRACK")
    private String smallcarSideswaySmallTraverseTrack;

    @ApiModelProperty(value = "小车横移机构制动器型号")
    @TableField("SMALLCAR_SIDESWAY_BRAKE_MODEL")
    private String smallcarSideswayBrakeModel;

    @ApiModelProperty(value = "小车横移机构制动力矩")
    @TableField("SMALLCAR_SIDESWAY_BRAK_TORQUE")
    private String smallcarSideswayBrakTorque;

    @ApiModelProperty(value = "小车横移机构小车横移车轮踏面直径")
    @TableField("SMALLCAR_SIDESWAY_TREAD_DIAMETER")
    private String smallcarSideswayTreadDiameter;

    @ApiModelProperty(value = "小车横移机构电机型号")
    @TableField("SMALLCAR_SIDESWAY_MOTOR_QUANTITY")
    private String smallcarSideswayMotorQuantity;

    @ApiModelProperty(value = "小车横移机构电机数量")
    @TableField("SMALLCAR_SIDESWAY_MOTOR_NUMBER")
    private Integer smallcarSideswayMotorNumber;

    @ApiModelProperty(value = "悬臂长度")
    @TableField("CANTILEVER_LENGTH")
    private String cantileverLength;

    @ApiModelProperty(value = "使用场所")
    @TableField("PLACE_USE")
    private String placeUse;

    @ApiModelProperty(value = "变幅速度")
    @TableField("DERRICKING_SPEED")
    private String derrickingSpeed;

    @ApiModelProperty(value = "最大幅度起重量")
    @TableField("MAXIMUM_LIFTING_CAPACITY")
    private String maximumLiftingCapacity;

    @ApiModelProperty(value = "导轨架")
    @TableField("GUIDE_RAIL_FRAME")
    private String guideRailFrame;

    @ApiModelProperty(value = "层数")
    @TableField("NUMBER_OF_PLIES")
    private Integer numberOfPlies;

    @ApiModelProperty(value = "整机重量")
    @TableField("OPERATING_WEIGHT")
    private String operatingWeight;

    @ApiModelProperty(value = "起升机构制动力矩")
    @TableField("HOIST_BRAKING_TORQUE")
    private String hoistBrakingTorque;

    @ApiModelProperty(value = "起升机构钢丝绳型号")
    @TableField("HOIST_WIRE_ROPE")
    private String hoistWireRope;

    @TableField("MAIN_MODEL_SPECIFICATION")
    private String mainModelSpecification;

    @TableField("MAIN_MANUFACTURER")
    private String mainManufacturer;

    @TableField("MAIN_MANUFACTURE_DATE")
    private Date mainManufactureDate;

    @TableField("MAIN_PRODUCT_NUMBER")
    private String mainProductNumber;

    @TableField("MAIN_NAME")
    private String mainName;

    @ApiModelProperty(value = "吊笼数量")
    @TableField("HANGING_CAGES_NUMBER")
    private String hangingCagesNumber;

}
