package com.yeejoin.amos.boot.module.jczs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jczs.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.jczs.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.jczs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.jczs.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.jczs.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.jczs.api.service.ITzBaseEnterpriseInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 企业数据信息
 *
 * @author duanwei
 * @date 2022-08-10
 */
@RestController
@Api(tags = "企业数据信息Api")
@RequestMapping(value = "/baseEnterprise", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TzBaseEnterpriseInfoController {

    @Autowired
    ITzBaseEnterpriseInfoService iTzBaseEnterpriseInfoService;

    @Autowired
    TzBaseEnterpriseInfoMapper baseEnterpriseInfoMapper;

    @Autowired
    RedisUtils redisUtils;

    /**
     * 新增企业数据信息
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增企业数据信息", notes = "新增企业数据信息")
    public boolean saveTzBaseEnterpriseInfo(HttpServletRequest request,
                                            @RequestBody TzBaseEnterpriseInfo tzBaseEnterpriseInfo) {
        return iTzBaseEnterpriseInfoService.save(tzBaseEnterpriseInfo);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iTzBaseEnterpriseInfoService.removeById(id);
    }

    /**
     * 修改企业数据信息
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改企业数据信息", notes = "修改企业数据信息")
    public boolean updateByIdTzBaseEnterpriseInfo(HttpServletRequest request,
                                                  @RequestBody TzBaseEnterpriseInfo tzBaseEnterpriseInfo) {
        return iTzBaseEnterpriseInfoService.updateById(tzBaseEnterpriseInfo);
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<TzBaseEnterpriseInfoDto> selectById(HttpServletRequest request, @PathVariable Long id) {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.detail(id));
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<TzBaseEnterpriseInfo>> listPage(String pageNum, String pageSize,
                                                               TzBaseEnterpriseInfo tzBaseEnterpriseInfo) {

        Page<TzBaseEnterpriseInfo> pageBean;
        QueryWrapper<TzBaseEnterpriseInfo> tzBaseEnterpriseInfoQueryWrapper = new QueryWrapper<>();
        Class<? extends TzBaseEnterpriseInfo> aClass = tzBaseEnterpriseInfo.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(tzBaseEnterpriseInfo);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(tzBaseEnterpriseInfo);
                        tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(tzBaseEnterpriseInfo);
                        tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(tzBaseEnterpriseInfo);
                        tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(tzBaseEnterpriseInfo);
                        tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<TzBaseEnterpriseInfo> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {

            pageBean = new Page<>(0, Integer.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iTzBaseEnterpriseInfoService.page(pageBean, tzBaseEnterpriseInfoQueryWrapper);
        return ResponseHelper.buildResponse(page);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/listBySupervise", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "查询指定监管单位下的单位,包括本级监管单位及下级", notes = "查询指定监管单位下的单位")
    public ResponseModel<List<TzBaseEnterpriseInfo>> getUnitList(@RequestParam(required = false) String superviseCompanySeq) {
        LambdaQueryWrapper<TzBaseEnterpriseInfo> tzBaseEnterpriseInfoQueryWrapper = new LambdaQueryWrapper<>();
        if(StringUtils.isNotEmpty(superviseCompanySeq)){
            String orgCode = baseEnterpriseInfoMapper.getOrgCodeByCompanySeq(superviseCompanySeq);
            tzBaseEnterpriseInfoQueryWrapper.likeRight(StringUtils.isNotEmpty(orgCode), TzBaseEnterpriseInfo::getSuperviseOrgCode, orgCode);
        }
        tzBaseEnterpriseInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        tzBaseEnterpriseInfoQueryWrapper.select(BaseEntity::getSequenceNbr,TzBaseEnterpriseInfo::getUseUnit, TzBaseEnterpriseInfo::getUseUnitCode);
        List<TzBaseEnterpriseInfo> units = iTzBaseEnterpriseInfoService.list(tzBaseEnterpriseInfoQueryWrapper);
        return ResponseHelper.buildResponse(units);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getEquInfo/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "通过企业id查询设备", notes = "通过企业id查询设备")
    public ResponseModel<List<EquEnterDto>> getInfo(@PathVariable(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.getInfo(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getEquInfoByUseUnit", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "通过企业名称查询设备", notes = "通过企业名称查询设备")
    public ResponseModel<List<EquEnterDto>> getInfoByUseUnit(String useUnit) {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.getInfoByUseUnit(useUnit));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<IPage<TzBaseEnterpriseInfoDto>> page(PageParam pageParam,
                                                              @RequestParam(value = "sort", required = false) String sort,
                                                              @RequestParam Map<String, Object> map) {
        TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto = JSON.parseObject(JSON.toJSONString(map), TzBaseEnterpriseInfoDto.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (!ValidationUtil.isEmpty(map.get("createDateRange"))){
            String createDateRangeObj = Objects.toString(map.get("createDateRange"));
            String[] split = createDateRangeObj.replace("[", "").replace("]", "").split(",");
            String startDateStr = split[0];
            String endDateStr = split[1];
            try {
                Date startDate = sdf.parse(startDateStr);
                Date endDate = sdf.parse(endDateStr);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.set(Calendar.HOUR_OF_DAY, 23);
                calendar.set(Calendar.MINUTE, 59);
                calendar.set(Calendar.SECOND, 59);
                calendar.set(Calendar.MILLISECOND, 999);
                endDate = calendar.getTime();
                tzBaseEnterpriseInfoDto.setCreateDateStart(startDate);
                tzBaseEnterpriseInfoDto.setCreateDateEnd(endDate);
            } catch (Exception e) {
            }
        }
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.page(pageParam, tzBaseEnterpriseInfoDto, sort));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/info", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "查询企业端当前登录人所在企业详情", notes = "查询企业端当前登录人所在企业详情")
    public ResponseModel<IPage<TzBaseEnterpriseInfoDto>> pageInfo(PageParam pageParam) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(reginParams)) {
            return null;
        }
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.page(pageParam, reginParams.getCompany().getCompanyName()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getInfoByUseCode", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据统一信用代码查询企业详情", notes = "根据统一信用代码查询企业详情")
    public ResponseModel<TzBaseEnterpriseInfoDto> getInfoByUseCode(String useCode) {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.getInfoByUseCode(useCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/companyInfoUpdate", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "修改企业信息", notes = "修改企业信息")
    public ResponseModel<TzBaseEnterpriseInfoDto> companyInfoUpdate(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.companyInfoUpdate(map));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/adminInfoUpdate", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "修改企业信息", notes = "修改企业信息")
    public ResponseModel<Object> adminInfoUpdate(@RequestBody Map<String, Object> map) {
        Map<String, Object> result = iTzBaseEnterpriseInfoService.adminInfoUpdate(map);
        if (result.containsKey("fail")) {
            ResponseModel responseModel = new ResponseModel();
            responseModel.setStatus(500);
            responseModel.setDevMessage(result.get("fail").toString());
            return responseModel;
        } else {
            return ResponseHelper.buildResponse(result.get("success"));
        }
    }

    /**
     * 根据企业名称查询企业详情
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getInfo", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据企业名称查询", notes = "根据企业名称查询")
    public ResponseModel<TzBaseEnterpriseInfoDto> selectByUseUnit(HttpServletRequest request, String useUnit) {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.selectByUseUnit(useUnit));
    }

    /**
     * 将监管系统全量用户导入 业务企业表 和 平台企业表
     *
     * @return OK
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/syncUnitData", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "同步企业信息", notes = "同步企业信息")
    public ResponseModel<String> syncUnitData() {
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.syncEnterpriseInfo());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/setLabel", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "设置企业标签", notes = "设置企业标签")
    public ResponseModel<Object> setLabel(@RequestBody Map<String, Object> map) {

        ArrayList<String> enterpriseLabel = new ArrayList<>();
        ArrayList<Long> enterpriseIds = (ArrayList) map.get("enterpriseIds");
        if (!ObjectUtils.isEmpty(map) && !ObjectUtils.isEmpty(map.get("enterpriseLabel")) && !ObjectUtils.isEmpty(map.get("enterpriseIds"))) {
            enterpriseLabel = (ArrayList) map.get("enterpriseLabel");
        }
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.setLabel(enterpriseIds, enterpriseLabel));

    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/export")
    @ApiOperation(httpMethod = "GET", value = "企业信息列表数据导出-废弃-整合到jg服务，统一导出", notes = "企业信息列表数据导出-废弃-整合到jg服务，统一导出")
    public void baseEnterpriseExport(HttpServletResponse response, String ids, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto) {
        iTzBaseEnterpriseInfoService.export(response, ids, tzBaseEnterpriseInfoDto);
    }
}
