package com.yeejoin.amos.boot.module.ymt.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
/**
 * 特种设备基本信息-设计信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tz_jg_design_info")
@ApiModel(value="TzsJgDesignInfo对象", description="特种设备基本信息-设计信息")
public class TzsJgDesignInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码(监管系统对接标识)")
    private String superviseCode;

    @ApiModelProperty(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;

    @ApiModelProperty(value = "设计单位名称")
    private String designUnitName;

    @ApiModelProperty(value = "设计许可编号")
    private String designLicenseNum;

    @ApiModelProperty(value = "设计使用年限")
    private Integer designUseDate;

    @ApiModelProperty(value = "设计日期")
    private Date designDate;

    @ApiModelProperty(value = "总图图号")
    private String drawingDo;

    @ApiModelProperty(value = "设计文件鉴定单位")
    private String appraisalUnit;

    @ApiModelProperty(value = "设计文件鉴定日期")
    private Date appraisalDate;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

}
