package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 大屏筛选过滤对象
 *
 * @author Administrator
 */
@Data
public class DPFilterParamForDetailDto {
    /**
     * 区域
     */
    @NotBlank(message = "区域编码不能为空！")
    private String cityCode;

    /**
     * 业务类型
     */
    private String businessType;
    /**
     * 具体业务类型 例如：安装告知、维修告知等
     * code对应统计服务中的jgdp_businessType.json
     */
    private String businessTypeCode;

    /**
     * 时间筛选
     */
    private DPFilterParamForDateDto timeSearchOne;

    /**
     * 当前页
     */

    private int current = 1;

    /**
     * 每页大小
     */
    private int size = 20;

    /**
     * 左侧树选中值
     */
    private String treeValue;

    /**
     * 设备种类
     */
    private String equListCode;

    /**
     * 设备类别
     */
    private String equCategoryCode;

    /**
     * 监管单位名称（接收单位/管辖机构）
     */
    private String superviseUnitName;

    /**
     * 企业单位名称（发起单位/使用单位）
     */
    private String companyName;

    /**
     * 维保单位名称
     */
    private String maintenanceCompanyName;

    /**
     * 地市名称
     */
    private String regionName;

    /**
     * 报警类型code
     */
    private String typeCode;

    /**
     * 警情来源code
     */
    private String alertSourceCode;

    /**
     * 警情类型code
     */
    private String alertTypeCode;

    /**
     * 气瓶充装异常情况（0:正常，1：异常）
     */
    private String anomalyType;

    /**
     * 地址
     */
    private String address;

    /**
     * 业务状态
     */
    private String status;

}
