package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipInsuranceDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipInsurance;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgEquipInsuranceMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgEquipInsuranceService;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author LiuLin
 * @date 2024-10-17
 */
@Service
public class JgEquipInsuranceServiceImpl extends BaseService<JgEquipInsurance,JgEquipInsurance,JgEquipInsuranceMapper> implements IJgEquipInsuranceService {

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private CommonServiceImpl commonServiceImpl;

    private static final String SECOND = "second";

    private static final String DEVICE_LIST = "deviceList";

    /**
     * 分页查询
     */
    public Page<JgEquipInsuranceDto> queryForJgEquipInsurancePage(Page<JgEquipInsurance> page,
                                                               @ApiParam(value = "排序字段") @RequestParam(value = "sort", required = false) String sort,
                                                               JgEquipInsuranceDto dto)   {
        SortVo sortMap = commonServiceImpl.sortFieldConversion(sort);
        return this.baseMapper.getListPage(page, sortMap, dto);
    }

    /**
     * 列表查询 示例
     */
    public List<JgEquipInsurance> queryForJgEquipInsuranceList()   {
        return this.queryForList("" , false);
    }

    @Transactional(rollbackFor = Exception.class)
    public Object save(JSONObject map) {
        // 从 Redis 中获取 ReginParams 对象
        ReginParams reginParams = JSONObject.parseObject(
                redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(),
                ReginParams.class
        );

        // 解析 secondMap 和设备保险信息
        JSONObject secondMap = map.getJSONObject("second");
        JgEquipInsurance equipInsurance = map.getObject(SECOND, JgEquipInsurance.class);

        // 获取设备列表并进行校验
        List<Map> deviceList = secondMap.getJSONArray(DEVICE_LIST).toJavaList(Map.class);
        if (CollectionUtils.isEmpty(deviceList)) {
            throw new BadRequest("请选择设备信息!");
        }

        // 使用流创建新的保险对象列表并保存
        return this.saveBatch(
                deviceList.stream()
                        .map(x -> {
                            JgEquipInsurance newInsurance = new JgEquipInsurance();
                            BeanUtils.copyProperties(equipInsurance, newInsurance);
                            newInsurance.setEquId(String.valueOf(x.get("record")));
                            newInsurance.setEquList(String.valueOf(x.get("EQU_LIST_CODE")));
                            newInsurance.setEquCategory(String.valueOf(x.get("EQU_CATEGORY_CODE")));
                            newInsurance.setEquDefine(String.valueOf(x.get("EQU_DEFINE_CODE")));
                            newInsurance.setRecUserId(reginParams.getUserModel().getUserId());
                            newInsurance.setRecUserName(reginParams.getUserModel().getUserName());
                            newInsurance.setRecDate(new Date());
                            newInsurance.setIsDelete(false);
                            return newInsurance;
                        })
                        .collect(Collectors.toList())
        );
    }

    public JgEquipInsuranceDto getDetail(Long sequenceNbr) {
        return this.getBaseMapper().getDetailById(sequenceNbr);
    }
}