package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.IJgTableDataExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * JG表格数据导出
 */
@RestController
@Api(tags = "JG表格数据导出")
@RequestMapping(value = "/dataExport")
public class JgTableDataExportController extends BaseController {


    private IJgTableDataExportService iJgTableDataExportService;

    public JgTableDataExportController(IJgTableDataExportService iJgTableDataExportService) {
        this.iJgTableDataExportService = iJgTableDataExportService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/gen")
    @ApiOperation(httpMethod = "GET", value = "工具辅助接口", notes = "工具辅助接口")
    public ResponseModel<String> httGen(String jsonName, String voName, String tableName) {
        iJgTableDataExportService.gen(jsonName, voName, tableName);
        return ResponseHelper.buildResponse("Ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/certificate")
    @ApiOperation(httpMethod = "GET", value = "登记证列表数据导出", notes = "登记证列表数据导出")
    public void certificateExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.certificate(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/maintenance")
    @ApiOperation(httpMethod = "GET", value = "维保备案列表数据导出", notes = "维保备案列表数据导出")
    public void maintenanceExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.maintenance(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/installation")
    @ApiOperation(httpMethod = "GET", value = "安装告知列表数据导出", notes = "安装告知列表数据导出")
    public void installationExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.installation(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/maintain")
    @ApiOperation(httpMethod = "GET", value = "维修告知列表数据导出", notes = "维修告知列表数据导出")
    public void maintainExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.maintain(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/reform")
    @ApiOperation(httpMethod = "GET", value = "改造告知列表数据导出", notes = "改造告知列表数据导出")
    public void reformExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.reform(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/transfer")
    @ApiOperation(httpMethod = "GET", value = "移装告知列表数据导出", notes = "移装告知列表数据导出")
    public void transferExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.transfer(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/registration")
    @ApiOperation(httpMethod = "GET", value = "使用登记列表数据导出", notes = "使用登记列表数据导出")
    public void registrationExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.registration(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationUnit")
    @ApiOperation(httpMethod = "GET", value = "单位变更列表数据导出", notes = "单位变更列表数据导出")
    public void changeRegistrationUnitExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.changeRegistrationUnit(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationReform")
    @ApiOperation(httpMethod = "GET", value = "改造登记列表数据导出", notes = "改造登记列表数据导出")
    public void changeRegistrationReformExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.changeRegistrationReform(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/enableDisable")
    @ApiOperation(httpMethod = "GET", value = "启用停用列表数据导出", notes = "启用停用列表数据导出")
    public void enableDisableExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.enableDisable(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/scrapCancel")
    @ApiOperation(httpMethod = "GET", value = "注销报废列表数据导出", notes = "注销报废列表数据导出")
    public void scrapCancelExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.scrapCancel(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationTransfer")
    @ApiOperation(httpMethod = "GET", value = "移装变更列表数据导出", notes = "移装变更列表数据导出")
    public void changeRegistrationTransferExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.changeRegistrationTransfer(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationName")
    @ApiOperation(httpMethod = "GET", value = "更名变更列表数据导出", notes = "更名变更列表数据导出")
    public void changeRegistrationNameExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.changeRegistrationName(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/vehicleInformation")
    @ApiOperation(httpMethod = "GET", value = "车气登记列表数据导出", notes = "车气登记列表数据导出")
    public void vehicleInformationExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.vehicleInformation(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeVehicleRegistrationUnit")
    @ApiOperation(httpMethod = "GET", value = "车用气瓶变更列表数据导出", notes = "车用气瓶变更列表数据导出")
    public void changeVehicleRegistrationUnitExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.changeVehicleRegistrationUnit(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/unregulatedEquip")
    @ApiOperation(httpMethod = "GET", value = "未纳管设备列表数据导出", notes = "未纳管设备列表数据导出")
    public void unregulatedEquipExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.unregulatedEquip(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/manageEquipment")
    @ApiOperation(httpMethod = "GET", value = "已纳管设备列表数据导出", notes = "已纳管设备列表数据导出")
    public void manageEquipmentExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.manageEquipment(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipTransfer")
    @ApiOperation(httpMethod = "GET", value = "设备移交列表数据导出", notes = "设备移交列表数据导出")
    public void equipTransferExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids,"未选择导出数据");
        iJgTableDataExportService.equipTransfer(response, Arrays.asList(ids.split(",")));
    }
}
