package com.yeejoin.amos.patrol.common.enums;

public enum LatentDangerStateEnum {
    待评审("待评审", 1),
    待治理("待治理", 2),
    安措计划中("安措计划中", 3),
    待验证("待验证", 4),
    治理完毕("治理完毕", 5),
    已撤销("已撤销", 6),
    延期治理申请("延期治理中", 7),
    延期治理申请待车间部门审核("延期治理待车间部门审核", 8),
    延期治理申请待公司审核("延期治理待公司审核", 9);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    LatentDangerStateEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static String getEnumName(Integer code) {
        String name = "";
        for(LatentDangerStateEnum type: LatentDangerStateEnum.values()) {
            if (type.getCode()==code) {
                name = type.getName();
                break;
            }
        }
        return name;
    }

    public static LatentDangerStateEnum getByCode(Integer code) {
        for (LatentDangerStateEnum l : LatentDangerStateEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }

    public static LatentDangerStateEnum getByCode(String code) {
        for (LatentDangerStateEnum l : LatentDangerStateEnum.values()) {
            if (l.getCode().equals(Integer.parseInt(code))) {
                return l;
            }
        }
        return null;
    }
}
