package com.yeejoin.amos.boot.module.jyjc.api.enums;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
public enum BusinessTypeEnum {

    /**
     * 业务类型枚举
     */
    JG_EQUIPMENT_HANDOVER("101", "设备移交"),

    JG_INSTALLATION_NOTIFICATION("102", "安装告知"),

    JG_MODIFICATION_NOTIFICATION("103", "改造告知"),

    JG_MAINTENANCE_NOTIFICATION("104", "维修告知"),

    JG_ADVICE_REMOVAL("105", "移装告知"),

    JG_MAINTENANCE_RECORD("106", "维保备案"),

    JG_USAGE_REGISTRATION("107", "使用登记"),

    JG_NAME_CHANGE_REGISTRATION("108", "更名变更登记"),

    JG_COMPANY_CHANGE_REGISTRATION("109", "单位变更登记"),

    JG_CHANGE_REGISTRATION("110", "移装变更登记"),

    JG_RENOVATION_REGISTRATION("111", "改造变更登记"),

    JG_EQUIPMENT_START("112-1", "设备启用"),
    JG_EQUIPMENT_STOP("112-2", "设备停用"),

    JG_EQUIPMENT_MOVE("113-1", "移装注销"),
    JG_EQUIPMENT_CANCEL("113-2", "报废注销"),

    JY_OPENING_APPLICATION("114", "业务开通"),

    JY_INSPECTION_APPLICATION_JD("115", "监督检验"),

    JY_INSPECTION_APPLICATION_DS("116", "定（首）检验"),

    JY_INSPECTION_APPLICATION_CHECK("117", "检验（含安全阀效验）");
    private final String code;

    private final String name;

    BusinessTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (BusinessTypeEnum enumOne : BusinessTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
