package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.enums.OpenBizTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.HashMap;
import java.util.List;

@Service
public class CommonserviceImpl {

    @Value("${jyjc.user-post:6615}")
    private String jyjcUserPost;

    @Value("${jyjc.user-post:6616}")
    private String jyjcBizUserPost;

    @Value("${jy.user-post:66151}")
    private String jyUserPost;

    @Value("${jc.user-post:66152}")
    private String jcUserPost;

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsUserInfoMapper userInfoMapper;

    @Autowired
    TzBaseEnterpriseInfoMapper enterpriseInfoMapper;


    /**
     * @return ReginParams
     * @description 获取当前用户注册信息
     */
    ReginParams getReginParamsOfCurrentUser() {
        return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
    }

    public List<TzsUserInfo> getUserInfosByUnitCode(String unitCode) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        userInfoQueryWrapper.like(TzsUserInfo::getPost, jyjcUserPost);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }

    public List<TzsUserInfo> getUserListByUnitCodeAndPost(String unitCode, String personType) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        this.castPersonType2Post(userInfoQueryWrapper, personType);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        userInfoQueryWrapper.select(TzsUserInfo::getPost, TzsUserInfo::getPhone, TzsUserInfo::getName, TzsUserInfo::getInnerPersonCode, BaseEntity::getSequenceNbr);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }

    private void castPersonType2Post(LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper, String personType) {
        if (personType.equals(OpenBizTypeEnum.JY.getCode())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jyUserPost);
        }
        if (personType.equals(OpenBizTypeEnum.JC.getCode())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jcUserPost);
        }
    }

    public List<TzsUserInfo> getBizUserInfosByUnitCode(String unitCode) {
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.eq("unit_code", unitCode);
        userInfoQueryWrapper.like("post", jyjcBizUserPost);
        userInfoQueryWrapper.isNotNull("amos_user_id");
        userInfoQueryWrapper.eq("is_delete", false);
        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }

    public List<TzsUserInfo> getUserPhonesByPersonCode(String personCode) {
        List<String> ids = StrUtil.split(personCode, ",");
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.in("sequence_nbr", ids);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    public List<TzBaseEnterpriseInfoDto> getInspectionUnitList() {
        return enterpriseInfoMapper.getInspectionUnitList();
    }

    public TzBaseEnterpriseInfo getInspectionUnitBySequenceNbr(Long sequenceNbr) {
        return enterpriseInfoMapper.selectBySeq(sequenceNbr);
    }


    @Async
    public void sendMessage(HashMap<String, String> smsParams, List<String> phones) {
        for (String phone : phones) {
            smsParams.put("mobile", phone);
            Systemctl.smsClient.sendCommonSms(smsParams);
        }
    }

}
