package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author DELL
 */
@Data
@TableName("wl_source_file")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "wl_source_file", description = "资源与文件关联关系表")
public class SourceFile extends BaseEntity {

    @ApiModelProperty(value = "文件路径")
    @TableField("file_path")
    private String filePath;

    @ApiModelProperty(value = "文件名称")
    @TableField("file_name")
    private String fileName;

    @ApiModelProperty(value = "文件分类")
    @TableField("file_category")
    private String fileCategory;

    @ApiModelProperty(value = "所属者")
    @TableField("source_id")
    private Long sourceId;

    @ApiModelProperty(value = "创建者")
    @TableField(value = "creator_id",fill = FieldFill.INSERT_UPDATE)
    private Long creatorId;

}
