package com.yeejoin.amos.api.openapi.face.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

/**
* 特种设备检验信息Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class InspectionInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;

    private List inspectionReport;

            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "设备代码")
    /**
    * 设备代码
    */
    private String equCode;
            @ApiModelProperty(value = "检验类型(1法定类监督检验 2法定类定期检验 3非法定类检验 4委托类检验)")
    /**
    * 检验类型(1法定类监督检验2法定类定期检验3非法定类检验4委托类检验)
    */
    private String inspectType;
            @ApiModelProperty(value = "检验机构名称")
    /**
    * 检验机构名称
    */
    private String inspectOrgName;
            @ApiModelProperty(value = "检验报告ID")
    /**
    * 检验报告ID
    */
    private String inspectReportNum;
            @ApiModelProperty(value = "检验人员")
    /**
    * 检验人员
    */
    private String inspectStaff;
            @ApiModelProperty(value = "检验日期")
    /**
    * 检验日期
    */
    private Date inspectDate;
            @ApiModelProperty(value = "检验结论(合格，复检合格等)")
    /**
    * 检验结论(合格，复检合格等)
    */
    private String inspectConclusion;
            @ApiModelProperty(value = "安全状况等级")
    /**
    * 安全状况等级
    */
    private String safetyLevel;
            @ApiModelProperty(value = "检验问题备注")
    /**
    * 检验问题备注
    */
    private String problemRemark;
            @ApiModelProperty(value = "下次检验日期")
    /**
    * 下次检验日期
    */
    private Date nextInspectDate;



}
