package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 警情填报业务数据项
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_repair_consult")
public class RepairConsult extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 警情id或者保修单id
     */
	@TableField("parent_id")
    private Long parentId;

    /**
     * 类型，0为故障报修，1为投诉咨询描述，2接警，3派遣，4抵达
     */
	@TableField("type")
    private String type;

    /**
     * 警情阶段
     */
	@TableField("alert_status")
    private String alertStatus;

    /**
     * 保修人或咨询人姓名
     */
	@TableField("contact_user")
    private String contactUser;

    /**
     * 保修人或咨询人联系人电话
     */
	@TableField("contact_phone")
    private String contactPhone;

    /**
     * 记录描述
     */
	@TableField("description")
    private String description;

    /**
     * 警情阶段code
     */
	@TableField("alert_stage_code")
    private String alertStageCode;

    /**
     * 阶段附件
     */
    @TableField("attachment")
	private String attachment;

}
