package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.vo.JgMaintenanceContractVo;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintenanceContractServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * 维保合同备案
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "维保合同备案Api")
@RequestMapping(value = "/jg-maintenance-contract")
public class JgMaintenanceContractController extends BaseController {

    @Autowired
    JgMaintenanceContractServiceImpl jgMaintenanceContractServiceImpl;

    @Autowired
    RedisUtils redisUtils;

    /**
     * 新增(提交)
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveOrSubmit")
    @ApiOperation(httpMethod = "POST", value = "新增维保合同备案", notes = "新增维保合同备案")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> save(@RequestBody Map<String, Object> model,
                                      @RequestParam(value = "submit") String submit) {
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.saveOrSubmit(submit, model, reginParams));
    }


    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/revocation")
    @ApiOperation(httpMethod = "POST", value = "维保合同撤回", notes = "维保合同撤回")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> revocation(@RequestBody JSONObject map) {
        jgMaintenanceContractServiceImpl.revocation(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Object> deleteBySequenceNbr(@RequestParam("sequenceNbr") Long sequenceNbr) {
        jgMaintenanceContractServiceImpl.deleteForBatch(new Long[]{sequenceNbr});
        return ResponseHelper.buildResponse("success");
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    @RequestMapping(value = "/batchDelete", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public ResponseModel<Boolean> deleteForBatch(Long[] ids) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.deleteForBatch(ids));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个维保合同备案", notes = "根据sequenceNbr查询单个维保合同备案")
    public ResponseModel<Object> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.queryBySequenceNbr(sequenceNbr, getSelectedOrgInfo().getCompany()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "维保备案执行流程", notes = "执行流程")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
        jgMaintenanceContractServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),
                String.valueOf(map.get("instanceId")),
                String.valueOf(map.get("operate")),
                String.valueOf(map.get("comment")),
                true,
                String.valueOf(map.get("nextTaskId")),
                map);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "维保合同备案分页查询", notes = "分页查询维保合同备案")
    public ResponseModel<Page<JgMaintenanceContractVo>> queryForPage(@RequestParam(value = "current") int current,
                                                                     @RequestParam(value = "size") int size,
                                                                     @RequestParam(value = "sort", required = false) String sort,
                                                                     @ApiParam(value = "客户端类型: jgAudit-监管审核;jgLook-监管查看")
                                                                         @RequestParam(value = "client", required = false, defaultValue = "jgAudit") String client,
                                                                     @RequestBody(required = false) JgMaintenanceContractDto dto) {
        Page<JgMaintenanceContract> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        ReginParams reginParams = getSelectedOrgInfo();
        Page<JgMaintenanceContractVo> contractDtoPage = jgMaintenanceContractServiceImpl.queryForPage(page, sort, dto, reginParams, client);
        return ResponseHelper.buildResponse(contractDtoPage);
    }

    /**
     * 列表分页查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancelApplication")
    @ApiOperation(httpMethod = "POST", value = "维保备案作废", notes = "维保备案作废")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgMaintenanceContract> cancelApplication(@RequestBody JgMaintenanceContractDto dto) {
        JgMaintenanceContract result = jgMaintenanceContractServiceImpl.cancelApplication(dto.getSequenceNbr(), dto.getCancelReason());
        return ResponseHelper.buildResponse(result);
    }
}
