package com.yeejoin.amos.boot.module.ymt.flc.api.entity;

import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 气瓶企业信息
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_unit")
@ApiModel(value="TzCylinderUnit对象", description="气瓶企业信息")
public class CylinderUnit extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位ID")
    private String unitId;

    @ApiModelProperty(value = "所属区域")
    private String regionCode;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "企业负责人")
    private String unitPerson;

    @ApiModelProperty(value = "企业负责人手机")
    private String personMobilePhone;

    @ApiModelProperty(value = "企业负责人固定电话")
    private String personTelephone;

    @ApiModelProperty(value = "企业邮编")
    private String postalCode;

    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "安全管理员")
    private String securityAdm;

    @ApiModelProperty(value = "安全管理员手机")
    private String securityAdmPhone;

    @ApiModelProperty(value = "所属区域")
    private String regionName;

    @ApiModelProperty(value = "技术服务商")
    private String developerAgency;
}
