package com.yeejoin.amos.boot.module.jczs.api.service;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jczs.api.dto.WechatMessageDto;

/**
 * 微信公众号服务类
 */
public interface IWechatService {

    /**
     * 获取token
     * @return
     */
    String getAccessToken();

    /**
     * 获取微信openId
     * @return
     */
    String getOpenId(String code);

    /**
     * 获取微信昵称
     * @param openId
     * @return
     */
    JSONObject getUserInfo(String openId);

    /**
     * 发送微信模板消息
     * @param openId
     * @return
     */
    JSONObject sendWechatModelMessage(String openId, WechatMessageDto wechatMessageDto);

    /**
     * 根据多媒体id 获取微信图片
     * @param mediaId
     * @return
     */
    String getWechatPicByMediaId(String mediaId);

    /**
     * 发送测试公众号督查整改模板消息
     *
     * @return
     */
	Boolean sendTestTemplateMsgSupervise();

    /**
     * 发送测试公众号预警模板消息
     *
     * @return
     */
    Boolean sendTestTemplateMsgWarning();
}
