package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业数据信息 Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-10
 */
@Mapper
public interface TzBaseEnterpriseInfoMapper extends BaseMapper<TzBaseEnterpriseInfo> {

    /**
     * 查找企业关联设备详情列表
     *
     * @param sequenceNbr 企业id
     * @return EquEnterDto 使用登记证代码、设备名称、设备类别、设备位置
     */
    List<EquEnterDto> getInfo(String sequenceNbr);

    /**
     * 根据企业名称查找设备
     *
     * @param useUnit 企业名称
     * @return
     */
    List<EquEnterDto> getInfoByUseUnit(String useUnit);

    /**
     * 根据企业名称查找企业详情信息
     *
     * @param useUnit
     * @return
     */
    TzBaseEnterpriseInfo selectByUseUnit(String useUnit);


    IPage<TzBaseEnterpriseInfoDto> page(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto);

    IPage<TzBaseEnterpriseInfoDto> pageList(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto, List orgCodeList);


    /**
     * 监查值守迁移接口
     * @param page 分页参数
     * @param tzBaseEnterpriseInfoDto 筛选条件
     * @param orgCodeList 机构
     * @return 分页
     */
    IPage<TzBaseEnterpriseInfoDto> pageList2(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto, List orgCodeList, List unitTypeList);


    /**
     * 查找企业关联设备详情列表
     */
    List<TzBaseEnterpriseInfoDto> getInspectionUnitList(String openBizType);

    List<TzBaseEnterpriseInfoDto> getInspectionUnitListByCode(@Param("list") List<String> codes, @Param("city") String city, @Param("openBizType") String openBizType);

    /**
     * 查询非自检机构的单位
     * @param codes 单位code
     * @param city 开通区县
     * @param openBizType 开通业务类型
     * @return 非自检机构开通的单位
     */
    List<TzBaseEnterpriseInfoDto> getInspectionUnitListByCodeNoZjjg(@Param("list") List<String> codes, @Param("city") String city, @Param("openBizType") String openBizType);

    /**
     * 根据ID查找企业详情信息
     *
     * @param sequenceNbr sequenceNbr
     * @return {@link  TzBaseEnterpriseInfo}
     * @throws
     * @author yangyang
     */
    TzBaseEnterpriseInfo selectBySeq(Long sequenceNbr);

    List<CountDto> countByUnitTypeAndOrgCode(@Param("orgCode") String orgCode, @Param("cityCode") String cityCode, @Param("isOrgCodeExactMatch") Boolean isOrgCodeExactMatch);

    List<CountDto> countByUnitTypeAndOrgCodeNoParam();

    /**
     * 按照状态统计
     *
     * @param orgCode         公司的orgCode
     * @param operatingStatus 营业状态
     * @param cityCode        区域code
     * @return Long   统计数量
     */
    Long countByOperatingStatusAndOrgCode(@Param("orgCode") String orgCode, @Param("operatingStatus") List<String> operatingStatus, @Param("cityCode") String cityCode);


    List<TzBaseEnterpriseInfoDto> queryByUseCode(@Param("useCodes") List<String> useCode);

    List<TzBaseEnterpriseInfoDto> selectExpiringUnits(@Param("operator")String operator);

    /**
     * 根据企业信用代码查询企业
     *
     * @param useUnitCode 企业信用代码
     * @return TzBaseEnterpriseInfo
     */
    TzBaseEnterpriseInfo selectByUseUnitCode(String useUnitCode);

    List<Map<String,String>> getEnterInfoWithExport(@Param("ids") List<String> ids);

    /**
     * 按照不带证件类型的的单位code，重新单位-检验检测业务专用
     * @param unitCode 单位code
     * @return 单位列表
     */
    List<TzBaseEnterpriseInfoDto> queryInspectionUnitListByUseUnitCode(@Param("unitCode") String unitCode, @Param("openBizType")  String openBizType);

}
