package com.yeejoin.amos.fas.business.feign;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.fas.business.jpush.PushMsgParam;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;



/**
 * 消息推送
 * @author maoying
 *
 */
@FeignClient(name = "${Push.fegin.name}", configuration={MultipartSupportConfig.class})
public interface PushFeign {

  
	    @RequestMapping(value = "/api/user/sendMessageone", method = RequestMethod.POST)
	    CommonResponse sendMessageone( @RequestBody PushMsgParam responses);
	    
	  
	    @RequestMapping(value = "/api/user/pushNoticeMany", method = RequestMethod.POST)
	    CommonResponse pushNoticeMany( @RequestBody PushMsgParam responses);
	    
	    @RequestMapping(value = "/api/user/buildPushPayload", method = RequestMethod.POST)
	    CommonResponse buildPushPayload( @RequestBody PushMsgParam responses);
	    
	    @RequestMapping(value = "/api/user/pushDevice", method = RequestMethod.GET)
	    CommonResponse PushDevice( @RequestParam("alias") String alias);
	    
	    @RequestMapping(value = "/api/user/PushDeviceRegistration", method = RequestMethod.GET)
	    CommonResponse PushDeviceRegistration( @RequestParam("registrationId") String registrationId,@RequestParam("alias") String alias);
}
