package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.common.api.dto.FormValue;
import com.yeejoin.amos.boot.module.common.api.dto.OrgPersonFormDto;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.jcs.api.dto.SinStaticDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Sign;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.jcs.biz.service.impl.SignServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.SignDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 打卡记录
 *
 * @author system_generator
 * @date 2022-08-15
 */
@RestController
@Api(tags = "打卡记录Api")
@RequestMapping(value = "/sign")
public class SignController extends BaseController {

    @Autowired
    SignServiceImpl signServiceImpl;

	@Autowired
	OrgUsrServiceImpl iOrgUsrService;
    /**
     * 新增打卡记录
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增打卡记录", notes = "新增打卡记录")
	public ResponseModel<SignDto> save(@RequestBody SignDto model) {
	    model = signServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新打卡记录", notes = "根据sequenceNbr更新打卡记录")
	public ResponseModel<SignDto> updateBySequenceNbrSign(@RequestBody SignDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(signServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除打卡记录", notes = "根据sequenceNbr删除打卡记录")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(signServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个打卡记录",  notes = "根据sequenceNbr查询单个打卡记录")
	public ResponseModel<SignDto> selectOne(@PathVariable Long sequenceNbr) {
		SignDto signDto = signServiceImpl.queryBySeq(sequenceNbr);
		QueryWrapper<OrgUsr> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("sequence_nbr",signDto.getSignUserId());
		queryWrapper.eq("is_delete",0);
		OrgUsr orgUsr = iOrgUsrService.getOne(queryWrapper);
		try {
			OrgPersonFormDto orgPersonFormDto = iOrgUsrService.selectPersonById(orgUsr.getSequenceNbr());
			List<FormValue> personImg = orgPersonFormDto.getDynamicFormAlert().stream().filter(e -> e.getKey().equals("personImg")).collect(Collectors.toList());
			signDto.setPersonPhotos(personImg.get(0).getValue());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ResponseHelper.buildResponse(signDto);

	}

	/**
     * 列表分页查询
     *
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/page")
	@ApiOperation(httpMethod = "POST",value = "打卡记录分页查询",  notes = "打卡记录分页查询")
	public ResponseModel<IPage<SignDto>> queryForPage(@RequestBody SignDto dto) {
	    Page<SignDto> page = new Page<SignDto>();
	    page.setCurrent(dto.getCurrent());
	    page.setSize(dto.getSize());
	    return ResponseHelper.buildResponse(signServiceImpl.queryForSignPageByMapper(page, dto));
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/static/page")
	@ApiOperation(httpMethod = "POST",value = "打卡记录分页查询",  notes = "打卡记录分页查询")
	public ResponseModel<IPage<SinStaticDto>> queryStaticForPage(@RequestBody SinStaticDto dto) {
		Page<SinStaticDto> page = new Page<>();
		page.setCurrent(dto.getCurrent());
		page.setSize(dto.getSize());
		return ResponseHelper.buildResponse(signServiceImpl.queryForSignStaticPageByMapper(page, dto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "打卡记录列表全部数据查询",   notes = "打卡记录列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SignDto>> selectForList() {
	    return ResponseHelper.buildResponse(signServiceImpl.queryForSignList());
	}


	/**
	 * 当前用户当天是否已打卡
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "打卡记录列表全部数据查询",   notes = "打卡记录列表全部数据查询")
	@GetMapping(value = "/hasSign")
	public ResponseModel<Boolean> hasSign(@RequestParam(value = "type" , required = false) String type,
										  @RequestParam(value = "userId" , required = false) String userId) {
		String date = DateUtils.stampToDate(new Date().getTime(),DateUtils.DATE_PATTERN);
		return ResponseHelper.buildResponse(signServiceImpl.hasSign(type,date,userId));
	}

	/**
	 * 保存打卡记录
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "保存打卡记录",   notes = "保存打卡记录")
	@PostMapping(value = "/saveSign")
	public ResponseModel<Boolean> hasSign(@RequestBody SignDto dto) {
		return ResponseHelper.buildResponse(signServiceImpl.saveSign(dto));
	}
}
