package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.FailureAuditDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureAuditServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 
 *
 * @author system_generator
 * @date 2021-08-04
 */
@RestController
@Api(tags = "故障维修审核Api")
@RequestMapping(value = "/common/failure-audit")
public class FailureAuditController extends BaseController {

    @Autowired
    FailureAuditServiceImpl failureAuditServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<Object>  save(@RequestBody FailureAuditDto model)  {
		try {
			return ResponseHelper.buildResponse(failureAuditServiceImpl.savemodel(model,getSelectedOrgInfo()));
		} catch (Exception e) {
			e.printStackTrace();
			return ResponseHelper.buildResponse(false);
		}
	}



    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<FailureAuditDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(failureAuditServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<FailureAuditDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FailureAuditDto> page = new Page<FailureAuditDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(failureAuditServiceImpl.queryForFailureAuditPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FailureAuditDto>> selectForList() {
	    return ResponseHelper.buildResponse(failureAuditServiceImpl.queryForFailureAuditList());
	}

	/**
	 * 审核列表记录查询
	 *根据关联主表faultId查询
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "审核列表记录查询",   notes = "审核列表记录查询")
	@GetMapping(value = "/list/{faultId}")
	public ResponseModel<List<FailureAudit>> findByFaultIDFotList(@PathVariable long faultId) {
		return ResponseHelper.buildResponse(failureAuditServiceImpl.findByfaultId(faultId));
	}
	
   
	
}
