package com.yeejoin.precontrol.common.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 奖励表
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_reward")
@ApiModel(value="Reward对象", description="奖励表")
public class Reward extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "奖励人id")
    private Long personId;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "奖励金额")
    private BigDecimal money;

    @ApiModelProperty(value = "状态（0-未兑换，1-已兑换）")
    private Integer status;

    @ApiModelProperty(value = "兑换日期")
    private Date exchangeDate;


}
