package com.yeejoin.precontrol.common.mapper;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.TaskPersonDto;
import com.yeejoin.precontrol.common.dto.TaskSalaryConfirmDto;
import com.yeejoin.precontrol.common.entity.TaskSalaryConfirm;
import com.yeejoin.precontrol.common.param.PersonParam;
import com.yeejoin.precontrol.common.vo.PersonVo;
import com.yeejoin.precontrol.common.vo.TaskPersonFeedbackVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmOneVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmVo;

/**
 * 薪资确认任务表 Mapper 接口
 *
 * @author duanwei
 * @date 2020-12-08
 */
public interface TaskSalaryConfirmMapper extends BaseMapper<TaskSalaryConfirm> {

	IPage<TaskSalaryConfirmVo> pageInfo(Page<TaskSalaryConfirmVo> page, TaskSalaryConfirmDto taskSalaryConfirmDto);

	IPage<TaskSalaryConfirmOneVo> pageTodo(Page<TaskSalaryConfirmOneVo> page,
			TaskSalaryConfirmOneVo taskSalaryConfirmOneVo);

	TaskSalaryConfirmOneVo pageTodoDetail(long taskPersonId, long personId);

	IPage<PersonVo> persons(Page<PersonVo> page, long taskId, PersonParam param);

	Integer paidRatio(long projectId, long companyId);

	List<PersonVo> warnPersons(int day);

	int firstReadCount(long personId);

	Map<String, Object> statistic(@Param("projectId") Long projectId, @Param("companyId") Long companyId,
			@Param("startDate") Date startDate, @Param("endDate") Date endDate, @Param("payType") String type);
	
	IPage<TaskPersonFeedbackVo> listNotice(Page<TaskPersonFeedbackVo> page, TaskSalaryConfirmDto taskSalaryConfirmDto);
	
	IPage<TaskPersonDto> listUnconfirm(Page<TaskPersonDto> page, TaskSalaryConfirmDto taskSalaryConfirmDto);
}
