package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgRelationEquipServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgRelationEquipDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 使用登记
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "使用登记Api")
@RequestMapping(value = "/jg-relation-equip")
public class JgRelationEquipController extends BaseController {

    @Autowired
    JgRelationEquipServiceImpl jgRelationEquipServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增使用登记", notes = "新增使用登记")
	public ResponseModel<JgRelationEquipDto> save(@RequestBody JgRelationEquipDto model) {
	    model = jgRelationEquipServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新使用登记", notes = "根据sequenceNbr更新使用登记")
	public ResponseModel<JgRelationEquipDto> updateBySequenceNbrJgRelationEquip(@RequestBody JgRelationEquipDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgRelationEquipServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除使用登记", notes = "根据sequenceNbr删除使用登记")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgRelationEquipServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个使用登记",  notes = "根据sequenceNbr查询单个使用登记")
	public ResponseModel<JgRelationEquipDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgRelationEquipServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "使用登记分页查询",  notes = "使用登记分页查询")
	public ResponseModel<Page<JgRelationEquipDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgRelationEquipDto> page = new Page<JgRelationEquipDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgRelationEquipServiceImpl.queryForJgRelationEquipPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "使用登记列表全部数据查询",   notes = "使用登记列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgRelationEquipDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgRelationEquipServiceImpl.queryForJgRelationEquipList());
	}
}
