package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRelationEquip;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgRelationEquipMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgUseRegistrationService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeginService;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.OtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.InspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.OtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgUseRegistrationServiceImpl extends BaseService<JgUseRegistrationDto, JgUseRegistration, JgUseRegistrationMapper> implements IJgUseRegistrationService {

    @Autowired
    private UseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    @Autowired
    private JgRelationEquipMapper jgRelationEquipMapper;
    @Autowired
    WorkFlowFeginService workFlowFeginService;
    public Page<Map<String, Object>> getList(JgUseRegistrationDto dto, Page<Map<String, Object>> page) {
        return this.baseMapper.getListPage(page, dto);
    }
    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page,String factoryNum,String equList,String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList , equCategory);
    }


    public void save(JSONObject map){
        UseInfo useInfo = new UseInfo();
        BeanUtil.copyProperties(map, useInfo);
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord, map.get("equipId"));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);
        LambdaQueryWrapper<InspectionDetectionInfo> inspectionLambda = new QueryWrapper<InspectionDetectionInfo>().lambda();
        inspectionLambda.eq(InspectionDetectionInfo::getRecord, map.get("equipId"));
        // 更新检验检测信息
        inspectionDetectionInfoMapper.update(inspectionDetectionInfo, inspectionLambda);
        // 使用登记信息
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo :: getRecord, map.get("equipId"));
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgUseRegistration.setSupervisoryCode(supervisoryCode);
        jgUseRegistration.setUseUnitName(useInfo.getUseUnitName());
        jgUseRegistration.setUseUnitCreditCode(useInfo.getUseUnitCreditCode());
        jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
//        jgUseRegistration.setAuditStatus();
//        jgUseRegistration.setUseRegistrationCode();

        this.save(jgUseRegistration);
        // 业务管理设备信息保存
        JgRelationEquip jgRelationEquip = new JgRelationEquip();
        jgRelationEquip.setBusinessId(jgUseRegistration.getSequenceNbr().toString());
        jgRelationEquip.setEquipId(map.get("equipId").toString());
        jgRelationEquip.setBusinessType(String.valueOf(BusinessTypeEnum.USAGE_REGISTRATION.getCode()));
        jgRelationEquipMapper.insert(jgRelationEquip);
        if (!ObjectUtils.isEmpty(map.get("submit"))){
            // 启动并执行流程
            String instanceId = startByVariable();
            if (ObjectUtils.isEmpty(instanceId)){
                // 执行流程
                flowExecute(instanceId, "1", "备注"+System.currentTimeMillis());
            }
            jgUseRegistration.setInstanceId(instanceId);
            this.update();
        }
    }

    public String   startByVariable (){
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("useRegistrationNew");
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

    public void flowExecute(String instanceId, String operate, String comment){
        try {
            AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(taskId);
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment+System.currentTimeMillis());
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            dto.setVariable(map);
            //执行流程
            AjaxResult ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);

            if (ObjectUtils.isEmpty(ajaxResult1)) {

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteBatch(List<Long> ids) {
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setIsDelete(true);
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.in(JgUseRegistration::getSequenceNbr, ids);
        this.update(jgUseRegistration, lambda);
    }

    public Map<String, Object> getDetail(String id) {
        Map<String, Object> detail = this.baseMapper.getDetail(id);
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(id);
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(id);
        detail.putAll(inspectDetail);
        detail.putAll(useDetail);
        detail.put("proDuctPhoto", JSON.parse(String.valueOf(detail.get("proDuctPhoto"))));
        detail.put("factoryStandard", JSON.parse(String.valueOf(detail.get("factoryStandard"))));
        detail.put("productQualityYieldProve", JSON.parse(String.valueOf(detail.get("productQualityYieldProve"))));
        detail.put("insUseMaintainExplanin", JSON.parse(String.valueOf(detail.get("insUseMaintainExplanin"))));
        detail.put("inspectReport", JSON.parse(String.valueOf(detail.get("inspectReport"))));
        return detail;
    }

}