package com.yeejoin.amos.boot.module.jyjc.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 业务开通申请表
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JyjcInspectionResultModel", description="业务开通申请表")
public class JyjcInspectionResultModel extends BaseModel {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检验检测单位编码")
    private String inspectionUnitCode;

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "报检单位编号")
    private String applicationUnitCode;

    @ApiModelProperty(value = "设备唯一标识")
    private String equipUnicode;

    @ApiModelProperty(value = "检验结果状态（已出、未出）")
    private String resultStatus;

    @ApiModelProperty(value = "核准证号/许可证号")
    private String licenseNumber;

    @ApiModelProperty(value = "检验报告编号")
    private String resultNo;

    @ApiModelProperty(value = "检验人员（多个逗号分割）")
    private String inspector;

    @ApiModelProperty(value = "内部人员代码")
    private String innerPersonCode;

    @ApiModelProperty(value = "检验结论")
    private String inspectionConclusion;

    @ApiModelProperty(value = "检验日期")
    private Date inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    private Date nextInspectionDate;

    @ApiModelProperty(value = "检验开始日期")
    private Date inspectionStartDate;

    @ApiModelProperty(value = "检验结束日期")
    private Date inspectionEndDate;

    @ApiModelProperty(value = "检验结果汇总")
    private String inspectionResultSummary;

    @ApiModelProperty(value = "不符合项")
    private String nonConformance;

    @ApiModelProperty(value = "整改情况")
    private String rectification;

    @ApiModelProperty(value = "备注(无用预留)")
    private String remark;

    @ApiModelProperty(value = "业务类型（与菜单对应拆表使用）")
    private String bizType;

}
