package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcOpeningApplication;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.GroupModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcOpeningApplicationServiceImpl;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcOpeningApplicationModel;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * @author system_generator
 * @date 2023-12-13
 */
@RestController
@Api(tags = "检验业务申请单api")
@RequestMapping(value = "/jyjc-opening-application")
public class JyjcOpeningApplicationController extends BaseController {

    @Autowired
    JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<JyjcOpeningApplicationModel> save(@RequestBody JyjcOpeningApplicationModel model) {
	    model = jyjcOpeningApplicationServiceImpl.saveOrUpdateModel(model, false);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "更新", notes = "更新")
	public ResponseModel<JyjcOpeningApplicationModel> updateBySequenceNbrJyjcOpeningApplication(@RequestBody JyjcOpeningApplicationModel model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.saveOrUpdateModel(model,false));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}/submit")
	@ApiOperation(httpMethod = "PUT", value = "保存并提交", notes = "保存并提交")
	public ResponseModel<JyjcOpeningApplicationModel> updateBySequenceNbrAndStartFlow(@RequestBody JyjcOpeningApplicationModel model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.saveOrUpdateModel(model,true));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/startFlow/{sequenceNbr}")
	@ApiOperation(httpMethod = "POST", value = "重新提交开通申请", notes = "重新提交开通申请")
	public ResponseModel<JyjcOpeningApplicationModel> resubmitJyjcOpeningApplication(@RequestBody JyjcOpeningApplicationModel model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.saveOrUpdateModel(model, true));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/detail")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<JyjcOpeningApplicationModel> selectOne(@RequestParam(value = "sequenceNbr", required = false) Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.queryDetail(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<JyjcOpeningApplicationModel>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,JyjcOpeningApplicationModel jyjcOpeningApplicationDto) {
	    Page<JyjcOpeningApplication> page = new Page<JyjcOpeningApplication>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.queryForJyjcOpeningApplicationPage(page,jyjcOpeningApplicationDto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JyjcOpeningApplicationModel>> selectForList() {
	    return ResponseHelper.buildResponse(jyjcOpeningApplicationServiceImpl.queryForJyjcOpeningApplicationList());
	}



	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "接收或者驳回业务开通申请",   notes = "接收或者驳回业务开通申请")
	@GetMapping(value = "/execueFlow")
	public void execueFlow(@RequestParam("op") String op, @RequestParam("instanceId") String instanceId,@RequestParam("comments") String comments) {
		jyjcOpeningApplicationServiceImpl.execueFlow(op,instanceId,comments);
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "撤回业务开通申请",   notes = "撤回业务开通申请")
	@GetMapping(value = "/stopFlow")
	public void overflow( @RequestParam("instanceId") String instanceId) {
		jyjcOpeningApplicationServiceImpl.stopFlow(instanceId);
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUserRole")
	@ApiOperation(httpMethod = "GET", value = "获取用户所属组", notes = "获取用户所属组")
	public ResponseModel<List<Long>> getUserRole() {
		AgencyUserModel userModel = Privilege.agencyUserClient.queryByUserId(RequestContext.getExeUserId()).getResult();
		List<RoleModel> roleModels = userModel.getOrgRoles()
											  .values().stream().flatMap(Collection::stream).collect(Collectors.toList());
		List<Long> roleIds = roleModels.stream().map(RoleModel::getSequenceNbr).distinct().collect(Collectors.toList());
		return ResponseHelper.buildResponse(roleIds);
	}

}
