package com.yeejoin.amos.boot.module.tcm.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.tcm.biz.utils.RedisUtil;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.List;

import static com.alibaba.fastjson.JSON.parseArray;

/**
 * requestContext设置
 * @author Administrator
 */
@Service
public class StartPlatformTokenService {

    @Autowired
    AmosRequestContext amosRequestContext;

    @Autowired
    RedisUtil redisUtil;


    public void getToken() {
        RequestContext.setProduct(amosRequestContext.getProduct());
        RequestContext.setAppKey(amosRequestContext.getAppKey());
        RequestContext.setToken(amosRequestContext.getToken());
    }


    public void setRequestContext() {
        RequestContext.setProduct(amosRequestContext.getProduct());
        RequestContext.setAppKey(amosRequestContext.getAppKey());
        RequestContext.setToken(amosRequestContext.getToken());
    }

    public List<RoleModel> getAllRole(){
        List<RoleModel> roleModels;
        if(redisUtil.hasKey(RedisUtil.ROLE_REDIS_KEY)){
            roleModels = parseArray(redisUtil.get(RedisUtil.ROLE_REDIS_KEY).toString(),RoleModel.class);
            return roleModels;
        } else {
            FeignClientResult<List<RoleModel>> roleListResult = Privilege.roleClient.queryRoleList(null, null);
            roleModels = roleListResult.getResult();
            redisUtil.set(RedisUtil.ROLE_REDIS_KEY, JSONObject.toJSONString(roleModels));
        }
        return roleModels;
    }


}
