package com.yeejoin.amos.patrol.business.dao.mapper;


import com.yeejoin.amos.patrol.dao.entity.RoutePointItem;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

public interface RoutePointItemMapper extends BaseMapper {

    public void updateRoutePointItem( RoutePointItem pointItem);

    int delRoutePointItemByRouteId(Long routeId);
    int delRoutePointItemByPointId(Long pointId);

    int delRoutePointItem(@Param("routeId") String routeId, @Param("pointId") Long pointId);
    int delRoutePoint(@Param("routeId") String routeId, @Param("pointId") Long pointId);

    public void insertRoutePointItem(RoutePointItem pointItem);

    /**
     * 根据装备编码查装备信息
     * @param equipCode 装备code
     * @return
     */
    HashMap<String, String> getEquipByCode(String equipCode);

    int delRoutePointItemInExclude(@Param("routePointId") Long routePointId, @Param("inputItemIds")  List<Long> inputItemIds);
}
