package com.yeejoin.amos.boot.module.common.api.entity;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 反馈建议表
 *
 * @author system_generator
 * @date 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_feedback_suggestions")
public class FeedbackSuggestions extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 创建人id
     */
    @TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 创建时间（填报时间）
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 问题类型（字典值）
     */
    @TableField("problem_type")
    private String problemType;

    /**
     * 问题描述
     */
    @TableField("problem_description")
    private String problemDescription;

    /**
     * 管辖机构org_code
     */
    @TableField("supervise_org_code")
    private String superviseOrgCode;

    /**
     * 管辖机构org_name
     */
    @TableField("supervise_org_name")
    private String superviseOrgName;

    /**
     * 上报企业统一信用代码
     */
    @TableField("company_code")
    private String companyCode;

    /**
     * 上报企业名称
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 上报人员id
     */
    @TableField("reporter_user_id")
    private String reporterUserId;

    /**
     * 上报人员姓名
     */
    @TableField("reporter_user_name")
    private String reporterUserName;

    /**
     * 联系人
     */
    @TableField("contact_person")
    private String contactPerson;

    /**
     * 联系电话
     */
    @TableField("contact_phone")
    private String contactPhone;

    /**
     * 回复状态（1：回复，0：未回复）
     */
    @TableField("status")
    private String status;

    /**
     * 附件
     */
    @TableField("files")
    private String files;

    /**
     * 附件
     */
    @TableField(value = "files" ,exist = false)
    private JSONArray filesArr;

    /**
     * 公司对应企业数据表seq
     */
    @TableField(value = "files" ,exist = false)
    private String companySeq;

}
