package com.yeejoin.amos.boot.module.jg.api.service;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationReform;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 改造变更登记接口类
 *
 * @author system_generator
 * @date 2023-12-20
 */
public interface IJgChangeRegistrationReformService {
    /**
     *
     * @param dto
     * @param page
     * @param roleIds
     * @return
     */
    Page<Map<String, Object>> getList(JgChangeRegistrationReformDto dto,String sort, Page<Map<String, Object>> page, List<String> roleIds);

    /**
     * @deprecated 保存数据-根据入参判断是暂存还是执行流程
     * @param map
     * @return
     */
    List<Map<String, Object>> save(JSONObject map);

    /**
     * @deprecated 根据流程执行情况推动工作流或者
     * @param instanceId
     * @param jgChangeRegistrationReform
     * @param operate
     * @param processTaskDTO
     */
    void updateExecuteIds(String instanceId, JgChangeRegistrationReform jgChangeRegistrationReform, String operate, ProcessTaskDTO processTaskDTO);

    /**
     * @deprecated 流程执行
     * @param id
     * @param instanceId
     * @param operate
     * @param comment
     * @param nextTaskId 页面上送下一任务id
     */
    void flowExecute(Long id, String instanceId, String operate, String comment, String nextTaskId);

    /**
     * @deprecated 根据流程id执行撤回操作
     * @param instanceId
     */
    void withdraw(String instanceId, String nextTaskId);

    /**
     * @deprecated 根据id批量删除数据
     * @param ids
     */
    void deleteBatch(List<Long> ids);

    /**
     * 根据当前的数据id获取详情
     * @param currentDocumentId
     * @param equipId
     * @return
     */
    Map<String, Object> getDetail(String currentDocumentId, String equipId, CompanyBo companyBo);

    /**
     * @deprecated 根据当前的数据id导出使用登记证
     * @param sequenceNbr
     * @param response
     */
    void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response, String printType);
}
