package com.yeejoin.amos.boot.module.jg.api.service;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 接口类
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface IJgInstallationNoticeService extends IService<JgInstallationNotice> {

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 安装告知
     */
    Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr, CompanyBo company);

    /**
     * 更新安装告知
     *
     * @param noticeDto 安装告知
     * @param op        操作类型
     */
    JgInstallationNoticeDto updateInstallationNotice(String submitType, JgInstallationNoticeDto noticeDto, String op);

    /**
     * 分页查询
     *
     * @param page   分页对象
     * @param model  查询参数
     * @param type   类型：enterprise-企业端、supervision-监管端
     * @param client 类型：jgAudit-监管审核;jgLook-监管查看
     * @return 安装告知列表
     */
    Page<Map<String, Object>> queryForJgInstallationNoticePage(Page<JgInstallationNotice> page, JgInstallationNoticeDto model, String type, String sort, ReginParams reginParams, String client);

    /**
     * 批量删除
     *
     * @param sequenceNbrs 主键
     * @return 是否删除成功
     */
    Boolean deleteForBatch(Long[] sequenceNbrs);

    /**
     * 保存安装告知单
     *
     * @param model      数据
     * @param submitType 保存类型
     */
    List<JgInstallationNotice> saveNotice(String submitType, JSONObject model, ReginParams reginParams);

    /**
     * 打印告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    void generateInstallationNoticeReport(Long sequenceNbr, HttpServletResponse response);

    /**
     * 获取登录人所在企业类型
     *
     * @return
     */
    Map<String,Object> getCompanyType();

    /**
     * 作废申请
     * @param sequenceNbr 业务唯一标识
     * @param cancelReason 作废原因
     * @return JgInstallationNoticeDto
     */
    JgInstallationNotice cancelApplication(Long sequenceNbr, String cancelReason);

    Object getDeviceListByProjectContraption(String projectContraptionSeq);
}
