package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEnableDisableDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEnableDisableServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-25
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-enable-disable")
public class JgEnableDisableController extends BaseController {

    @Autowired
    JgEnableDisableServiceImpl jgEnableDisableServiceImpl;

    @Autowired
    RedisUtils redisUtils;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<Object> save(@RequestBody JSONObject map) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        return ResponseHelper.buildResponse(jgEnableDisableServiceImpl.saveOrUpdate(map, reginParams));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "使用登记设备关系表分页查询", notes = "使用登记设备关系表分页查询")
    public ResponseModel<Page<Map<String, Object>>> page(@RequestParam(value = "current") int current,
                                                         @RequestParam(value = "size") int size,
                                                         @RequestParam(value = "sort",required = false) String sort,
                                                         JgEnableDisableDto dto) {
        Page<Map<String, Object>> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jgEnableDisableServiceImpl.pageList(page,sort, dto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
        jgEnableDisableServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),
                String.valueOf(map.get("instanceId")),
                String.valueOf(map.get("operate")),
                String.valueOf(map.get("comment")),
                String.valueOf(map.get("nextTaskId")));
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/withdraw")
    @ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
    public ResponseModel<Object> withdraw(@RequestBody JSONObject map) {
        jgEnableDisableServiceImpl.withdraw(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")));
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "DELETE", value = "删除", notes = "删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("sequenceNbr") Long sequenceNbr) {
        jgEnableDisableServiceImpl.deleteMessage(sequenceNbr);
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detail")
    @ApiOperation(httpMethod = "GET", value = "详情", notes = "详情")
    public ResponseModel<Object> detail(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgEnableDisableServiceImpl.getDetail(sequenceNbr, getSelectedOrgInfo().getCompany()));
    }
}
