package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.common.BaseException;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipTransferServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备移交
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "设备移交Api")
@RequestMapping(value = "/jg-equip-transfer")
public class JgEquipTransferController extends BaseController {

    @Autowired
    JgEquipTransferServiceImpl jgEquipTransferServiceImpl;

    /**
     * 新增设备移交
     *
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增设备移交", notes = "新增设备移交")
    public ResponseModel<Object> save(@RequestParam("submitType") String submitType, @RequestBody JSONObject model) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.saveTransfer(submitType, model, getSelectedOrgInfo()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备移交", notes = "根据sequenceNbr更新设备移交")
    public ResponseModel<Object> updateBySequenceNbr(@RequestParam("submitType") String submitType,
                                                     @RequestBody JgEquipTransferDto equipTransferDto,
                                                     @RequestParam(value = "op", required = false) String op) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.updateEquipTransfer(submitType, equipTransferDto, op, getSelectedOrgInfo()));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备移交", notes = "根据sequenceNbr删除设备移交")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 批量删除
     *
     * @param ids 主键
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除设备移交", notes = "批量删除设备移交")
    public ResponseModel<Object> deleteBySequenceNbr(@RequestParam("ids") Long[] ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("请选择需要删除的行！");
        }
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.deleteForBatch(ids));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个设备移交", notes = "根据sequenceNbr查询单个设备移交")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.queryBySequenceNbr(sequenceNbr, getSelectedOrgInfo().getCompany()));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return Page
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "设备移交分页查询", notes = "设备移交分页查询")
    public ResponseModel<Page<JgEquipTransferDto>> queryForPage(@RequestParam(value = "current") int current,
                                                                @RequestParam(value = "size") int size,
                                                                @RequestParam(value = "sort", required = false) String sort,
                                                                @RequestBody(required = false) JgEquipTransferDto dto) {
        Page<JgEquipTransferDto> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.queryForJgEquipTransferPage(page, sort, dto, getSelectedOrgInfo()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCodeAndName")
    @ApiOperation(httpMethod = "GET", value = "获取当前登录用户所在公司code和公司名称", notes = "获取当前登录用户所在公司code和公司名称")
    public ResponseModel<Map<String, Object>> getCodeAndName() {

        List<CompanyModel> companyModels = FeignUtil.remoteCall(() -> Privilege.companyClient.queryListByChild(RequestContext.getExeUserId()));
        if (companyModels.isEmpty()) {
            throw new BaseException("未指定人员归属单位信息");
        }
        String companyType = companyModels.get(0).getCompanyType();
        String companyCode = companyModels.get(0).getCompanyCode();
        String companyName = companyModels.get(0).getCompanyName();
        Map<String, Object> map = new HashMap<>();
        if ("个人主体".equals(companyType)) {
            AgencyUserModel userModel = FeignUtil.remoteCall(() -> Privilege.agencyUserClient.queryByUserId(RequestContext.getExeUserId()));
            map.put("useUnitName", companyName.split("_")[1]);
            map.put("useUnitCreditCode", companyCode.split("_")[1]);
            map.put("phone", userModel.getMobile());
            map.put("sequenceNbr", userModel.getSequenceNbr());
            map.put("companyType", "person");
        } else {
            map.put("useUnitName", companyName);
            map.put("useUnitCreditCode", companyCode);
            map.put("companyType", "company");
        }
        return ResponseHelper.buildResponse(map);
    }


    /**
     * 查询有使用登记证，不在流程中的，已纳管的，装置父ID为空的数据
     *
     * @param useUnitCreditCode 使用单位code
     * @param current           当前页
     * @param size              每页数
     * @return page
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/finishSy/proCon")
    @ApiOperation(value = "查询指定使用单位下的可用装置，已纳管且使用登记证编号为空或者null", notes = "不包括流程中的")
    public ResponseModel<IPage<IdxBizJgProjectContraption>> getJgProjectContraptionPage(@RequestParam String useUnitCreditCode,
                                                                                        @RequestParam(value = "current") int current,
                                                                                        @RequestParam(value = "size") int size) {
        Page<IdxBizJgProjectContraption> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.getJgProjectContraptionPage(useUnitCreditCode, page));
    }
}

