package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.JgTransferNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 移装造告知
 *
 * @author system_generator
 * @date 2023-12-19
 */
@RestController
@Api(tags = "移装造告知Api")
@RequestMapping(value = "/jg-transfer-notice")
public class JgTransferNoticeController extends BaseController {

    @Autowired
    private IJgTransferNoticeService jgTransferNoticeService;

    @Autowired
    private ICommonService commonService;

    @Autowired
    private IJgInstallationNoticeService iJgInstallationNoticeService;

    /**
     * 新增移装造告知
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增移装造告知", notes = "新增移装造告知")
    public ResponseModel<String> save(@RequestParam String submitType, @RequestBody Map<String, Object> model) {
        ReginParams reginParams = getSelectedOrgInfo();
        jgTransferNoticeService.saveNotice(submitType, model, reginParams);
        return ResponseHelper.buildResponse("");
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新移装造告知", notes = "根据sequenceNbr更新移装造告知")
    public ResponseModel<JgTransferNoticeDto> updateBySequenceNbrJgTransferNotice(
            @RequestParam String submitType,
            @RequestBody Map<String, Object> model,
            @RequestParam(value = "op", required = false) String op) {
        JgTransferNoticeDto transferNoticeInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get("transferNoticeInfo")), JgTransferNoticeDto.class, true);
        if (Objects.isNull(transferNoticeInfo)) {
            throw new IllegalArgumentException("参数transferInfo不能为空");
        }
        return ResponseHelper.buildResponse(jgTransferNoticeService.updateTransferNotice(submitType, transferNoticeInfo, op));

    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除移装造告知", notes = "根据sequenceNbr删除移装造告知")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        jgTransferNoticeService.deleteForBatch(new Long[]{sequenceNbr});
        return ResponseHelper.buildResponse(Boolean.TRUE);
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @param sequenceNbrs 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batchDelete")
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Boolean> deleteForBatch(@RequestParam("sequenceNbrs") Long[] sequenceNbrs) {
        try {
            return ResponseHelper.buildResponse(jgTransferNoticeService.deleteForBatch(sequenceNbrs));
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个移装造告知", notes = "根据sequenceNbr查询单个移装造告知")
    public ResponseModel<Map<String, Map<String, Object>>> selectOne(@RequestParam Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgTransferNoticeService.queryBySequenceNbr(sequenceNbr, getSelectedOrgInfo().getCompany()));
    }


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "移装造告知分页查询", notes = "移装造告知分页查询")
    public ResponseModel<Page<Map<String, Object>>> queryForPage(
            @ApiParam(value = "当前页码", required = true) @RequestParam(value = "current", defaultValue = "1") int current,
            @ApiParam(value = "每页大小", required = true) @RequestParam(value = "size", defaultValue = "20") int size,
            @ApiParam(value = "排序字段", required = false) @RequestParam(value = "sort", required = false) String sort,
            @ApiParam(value = "类型：enterprise-企业端、supervision-监管端", required = true) @RequestParam(value = "type", defaultValue = "enterprise") String type,
            @RequestBody(required = false) JgTransferNoticeDto model
    ) {
        Page<JgTransferNotice> page = new Page<>(current, size);
        ReginParams reginParams = getSelectedOrgInfo();
        type = (String) iJgInstallationNoticeService.getCompanyType().get("companyLevel");
        return ResponseHelper.buildResponse(jgTransferNoticeService.queryForJgTransferNoticePage(page, sort, model, type, reginParams));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "移装告知列表全部数据查询", notes = "移装造告知列表全部数据查询")
    @GetMapping(value = "/generate-report")
    public void selectForList(HttpServletResponse response, @RequestParam("sequenceNbr") Long sequenceNbr) {
        jgTransferNoticeService.generateTransferNoticeReport(sequenceNbr, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "（测试使用）特种设备登记证导出", notes = "（测试使用）特种设备登记证导出")
    @GetMapping(value = "/certificate/report")
    public void generateCertificateReport(HttpServletResponse response) {
        Map<String, Object> map = new HashMap<>();
        // 组装模板变量
        map.put("manageType", "unit"); // 编号
        map.put("useRegistrationCode", "容3T陕A0001"); // 编号
        map.put("useUnitName", "西安市高科物业服务有限公司");  // 使用单位名称
        map.put("fullAddress", "西安市曲江新区春临东街南湖意境1单元2号楼");  // 设备使用地点
        map.put("equList", "电梯");  // 设备种类
        map.put("equDefine", "曳引驱动电梯啊啊啊啊啊啊啊啊啊啊啊啊啊");  // 设备品种
        map.put("equipCode", "");  // 设备代码
        map.put("equCategory", "压力管道");  // 设备类别
        map.put("useInnerCode", "KY-9527555555555555");  // 单位内编号
        map.put("factoryNum", "FUCK-G600010000056");  // 产品编号
        map.put("receiveOrgName", "西安市曲江新区质检院");  // 登记机关
        map.put("giveOutYear", "2023");  // 发证日期-年
        map.put("giveOutMonth", "12");  // 发证日期-月
        map.put("giveOutDay", "26");  // 发证日期-日
        map.put("supervisoryCode", "YZGZ20231225001");  // 监管二维码
        commonService.generateCertificateReport(map, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "（测试使用）特种设备登记证套打", notes = "（测试使用）特种设备登记证套打")
    @GetMapping(value = "/generate/pdf/print")
    public void printing(HttpServletResponse response) {
        Map<String, Object> map = new HashMap<>();
        map.put("useRegistrationCode", "梯10 陕B00005（24）");
        map.put("useUnitName", "西安市高科物业服务有限公司");
        map.put("fullAddress", "西安市曲江新区春临东街南湖意境1单元2号楼");
        map.put("equList", "场（厂）内专用机动车辆");
        map.put("equDefine", "特种气瓶（内装填料气瓶、纤维缠绕气瓶、低温绝热气瓶）");
        map.put("equCode", "31006102002024010001");
        map.put("equCategory", "非公路用旅游观光车辆");
        map.put("useInnerCode", "NBBH-1231231231");
        map.put("factoryNum", "CCBH-2312312312");
        map.put("giveOutYear", "2024");
        map.put("giveOutMonth", "12");
        map.put("giveOutDay", "26");
        map.put("supervisoryCode", "YZGZ20231225001");
        commonService.generatePdfPrint(map, response);
    }
}
