package com.yeejoin.amos.boot.module.jg.biz.edit.core;

import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import lombok.Getter;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;

@Getter
@Component("defaultEventPublisher")
public class DefaultEventPublisher implements IEventPublisher<BaseBizDataChangeEvent>, ApplicationEventPublisherAware {

    private ApplicationEventPublisher publisher;

    @Override
    public void publish(BaseBizDataChangeEvent event) {
        publisher.publishEvent(event);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

}
