package com.yeejoin.amos.boot.module.jg.biz.edit.factory;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;

@Component
@RequiredArgsConstructor
public class ColumnDiffFactory {
    private final List<IColumnDiff> IColumnDiffs;

    public IColumnDiff getDiffAdapter(Class<?> clazz) {
        for (IColumnDiff columnDiff : IColumnDiffs) {
            if (columnDiff.supports(clazz)) {
                return columnDiff;
            }
        }
        throw new BadRequest("no found handler for class: " + clazz);
    }
}
