package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.api.dto.DynamicColumnDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jyjc.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.enums.BizTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.EquipCategoryEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultDataModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultAttachmentService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultService;
import com.yeejoin.amos.boot.module.jyjc.api.vo.JyjcInspectionResultVo;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionDetectionSaveToDbEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.UseInfoSaveToDbEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.BizEmqPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.util.JsonUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.AbstractEquipBaseEntity;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipTechParamPipeline;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.feign.systemctl.model.DictionarieModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 业务开通申请表服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionResultServiceImpl extends BaseService<JyjcInspectionResultModel, JyjcInspectionResult, JyjcInspectionResultMapper> implements IJyjcInspectionResultService {

    private static final String JYJC_SUBMIT_FILE_PREFIX = "JYJC_";
    private static final String JYJC_SUBMIT_FILE_JYBG = "JYBG";
    private static final String JYJC_SUBMIT_KEY = "inspectResult";

    private static final String JYJC_RESULT_STATUS = "2";

    @Autowired
    private IJyjcInspectionResultAttachmentService iJyjcInspectionResultAttachmentService;

    @Autowired
    private IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    @Value("classpath:/json/equipCategory.json")
    private Resource equipCategory;

    @Autowired
    JyjcInspectionResultMapper resultMapper;

    @Autowired
    JyjcInspectionResultParamServiceImpl resultParamService;
    @Autowired
    JyjcInspectionResultAttachmentServiceImpl attachmentService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    UseInfoMapper useInfoMapper;

    @Autowired
    InspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    @Autowired
    private SnowflakeIdUtil sequence;

    @Autowired
    CommonServiceImpl commonService;

    @Autowired
    TzsUserInfoMapper tzsUserInfoMapper;

    @Autowired
    EventPublisher eventPublisher;

    @Autowired
    BizEmqPublisher bizEmqPublisher;

    @Autowired
    private ESEquipmentCategory esEquipmentCategory;

    @Autowired
    JyjcInspectionApplicationServiceImpl inspectionApplicationService;

    @Autowired
    private CommonMapper jgCommonMapper;

    @Autowired
    private ObjectMapper objectMapper;

    @Autowired
    private EquipTechParamPipelineMapper techParamPipelineMapper;

    /**
     * 检验检测单位分页查询
     */
    public Page<JyjcInspectionResultModel> queryForJyjcInspectionResultPage(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, boolean type) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        if (type) {
            //检验检测单位分页查询
            model.setInspectionUnitCode(reginParams.getCompany().getCompanyCode());
        } else {
            //报检单位分页查询
            model.setApplicationUnitCode(reginParams.getCompany().getCompanyCode());
        }
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectJyjcInspectionResultpPage(page, model);
        resultPage.getRecords().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            }
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
            }
        });
        return resultPage;
    }

    public Page<JyjcInspectionResultModel> queryForPageList(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, String sort) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        SortVo sortMap = commonService.sortFieldConversion(sort);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        // 判断当前登录人身份（报检机构、接收机构、即时报检又是接收机构、都不是（不存在此情况））
        String identity = this.getCompanyIdentityByType(reginParams.getCompany().getCompanyType());
        model.setCompanyCode(reginParams.getCompany().getCompanyCode());
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectForPage(page, model, identity, sortMap);
        resultPage.getRecords().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            }
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
            }
            v.setIdentity(identity);
        });
        return resultPage;
    }

    private String getCompanyIdentityByType(String companyType) {
        // 可发起单位的单位类型（角色与单位类型已绑定，在业务系统增加的账号不会出现角色与的单位类型不匹配场景）
        String[] applyIdentityDefine = {"使用单位", "安装改造维修单位"};
        // 可进行检验检测申请接收的单位类型，在业务系统增加的账号不会出现角色与的单位类型不匹配场景
        String[] receiveIdentityDefine = {"检验检测机构"};
        boolean isApplyIdentityMatch = false;
        boolean isReceiveIdentityMatch = false;
        if (Arrays.stream(applyIdentityDefine).anyMatch(companyType::contains)) {
            isApplyIdentityMatch = true;
        }
        if (Arrays.stream(receiveIdentityDefine).anyMatch(companyType::contains)) {
            isReceiveIdentityMatch = true;
        }
        if (isApplyIdentityMatch && !isReceiveIdentityMatch) {
            return "apply";
        }
        if (!isApplyIdentityMatch && isReceiveIdentityMatch) {
            return "receive";
        }
        if (isApplyIdentityMatch) {
            return "all";
        }
        return "no";
    }

    static String getPersonIdentityByType(String companyType) {
        if ("使用单位".equals(companyType)) {
            return BizTypeEnum.FIRST_INSPECTION.getCode();
        } else if ("安装改造维修单位".equals(companyType)) {
            return BizTypeEnum.SUPERVISE.getCode();
        } else {
            return "";
        }
    }


    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionResultModel updateJyjcInspectionResult(Map<String, Map<String, Object>> tableModel) {

        Map<String, Object> map = tableModel.get(JYJC_SUBMIT_KEY);

        JyjcInspectionResultModel model = BeanUtil.mapToBean(map, JyjcInspectionResultModel.class, true);
        String inspector = model.getInspector();
        if (StringUtil.isNotEmpty(inspector)) {
            List jsonArray = JSONArray.parseArray(inspector);
            Object inspectors = jsonArray.stream().map(String::valueOf).collect(Collectors.joining(","));
            model.setInspector(String.valueOf(inspectors));
        }
        model.setResultStatus(JYJC_RESULT_STATUS);

        // 更新结果主表
        updateWithModel(model);

        // 更新附件表
        List<JyjcInspectionResultAttachment> attachmentList = new ArrayList<>();
        LambdaQueryWrapper<JyjcInspectionResultAttachment> fileWrapper = new LambdaQueryWrapper<>();
        fileWrapper.eq(JyjcInspectionResultAttachment::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultAttachment> fileList = attachmentService.list(fileWrapper);
        JyjcInspectionResultAttachment jybgFile = new JyjcInspectionResultAttachment();

        map.forEach((k, v) -> {
            if (k.contains(JYJC_SUBMIT_FILE_PREFIX)) {
                JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
                attachment.setResultSeq(model.getSequenceNbr());
                attachment.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                attachment.setAttachmentType(k);
                // 新增时需要判断之前有就更新
                if (!CollectionUtils.isEmpty(fileList)) {
                    List<JyjcInspectionResultAttachment> collect = fileList.stream().filter(obj -> k.equals(obj.getAttachmentType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        JyjcInspectionResultAttachment jyjcInspectionResultAttachment = collect.get(0);
                        attachment.setSequenceNbr(jyjcInspectionResultAttachment.getSequenceNbr());
                    }
                }
                attachmentList.add(attachment);
                if (k.contains(JYJC_SUBMIT_FILE_JYBG)) {
                    jybgFile.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                    attachment.setAttachmentType(k);
                }
            }
        });
        if (!CollectionUtils.isEmpty(attachmentList)) {
            attachmentService.saveOrUpdateBatch(attachmentList);
        }

        // 更新参数表
        LambdaQueryWrapper<JyjcInspectionResultParam> paramWrapper = new LambdaQueryWrapper<>();
        paramWrapper.eq(JyjcInspectionResultParam::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultParam> params = resultParamService.list(paramWrapper);
        List<JyjcInspectionResultParam> paramList = new ArrayList<>();
        tableModel.forEach((k, v) -> {
            if (!JYJC_SUBMIT_KEY.equals(k) && !ObjectUtils.isEmpty(tableModel.get(k))) {
                List<JyjcInspectionResultParam> collect = params.stream().filter(p -> k.equals(p.getParamType())).collect(Collectors.toList());
                JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
                if (!CollectionUtils.isEmpty(collect)) {
                    resultParam.setSequenceNbr(collect.get(0).getSequenceNbr());
                }
                resultParam.setParamType(k);
                resultParam.setResultSeq(model.getSequenceNbr());
                resultParam.setParamJson(JSON.toJSONString(tableModel.get(k)));
                paramList.add(resultParam);
            }
        });
        if (!CollectionUtils.isEmpty(paramList)) {
            resultParamService.saveOrUpdateBatch(paramList);
        }
        JyjcInspectionResultModel dbResultModel = this.queryBySeq(model.getSequenceNbr());
        // 更新使用信息、检验信息、技术参数
        this.updateTechParamAndInspectInfo(dbResultModel, jybgFile);
        // 更新单据信息的json（公共）
        this.updateHisDataAfterResultUpdate(dbResultModel);
        return dbResultModel;
    }


    private void updateTechParamAndInspectInfo(JyjcInspectionResultModel model, JyjcInspectionResultAttachment jybgFile){
        if(model.getEquList().equals(EquipmentClassifityEnum.YLGD.getCode())){
            // 管道逻辑： 循环更新技术参数、检验信息更新或者插入、使用信息更新(数据库及es)
            JyjcInspectionResultParam param = iJyjcInspectionResultParamService.getOneParamByResultSeq(model.getSequenceNbr());
            if (!ObjectUtils.isEmpty(param.getParamJson())) {
                JSONObject paramObj = JSON.parseObject(param.getParamJson());
                try {
                    List<Map<String, Object>> equips = objectMapper.readValue(
                            objectMapper.writeValueAsString(paramObj.get("equip")),
                            new TypeReference<ArrayList<Map<String, Object>>>() {
                            }
                    );
                    equips.forEach(e->{
                        String record = String.valueOf(e.get("record"));
                        // 1.更新管道的技术参数
                        EquipTechParamPipeline techParamPipeline = new EquipTechParamPipeline();
                        BeanUtil.copyProperties(e, techParamPipeline,true);
                        LambdaUpdateWrapper<EquipTechParamPipeline> updateWrapper = new LambdaUpdateWrapper<>();
                        updateWrapper.eq(AbstractEquipBaseEntity::getRecord, record);
                        updateWrapper.set(EquipTechParamPipeline::getNominalDiameter, techParamPipeline.getNominalDiameter());
                        updateWrapper.set(EquipTechParamPipeline::getWallThickness, techParamPipeline.getWallThickness());
                        updateWrapper.set(EquipTechParamPipeline::getPipeLength, techParamPipeline.getPipeLength());
                        updateWrapper.set(EquipTechParamPipeline::getPressure, techParamPipeline.getPressure());
                        updateWrapper.set(EquipTechParamPipeline::getTemperature, techParamPipeline.getTemperature());
                        updateWrapper.set(EquipTechParamPipeline::getMedium, techParamPipeline.getMedium());
                        updateWrapper.set(EquipTechParamPipeline::getWorkMedium, techParamPipeline.getWorkMedium());
                        updateWrapper.set(EquipTechParamPipeline::getWorkPressure, techParamPipeline.getWorkPressure());
                        updateWrapper.set(EquipTechParamPipeline::getWorkTemperature, techParamPipeline.getWorkTemperature());
                        updateWrapper.set(EquipTechParamPipeline::getRemarks, techParamPipeline.getRemarks());
                        techParamPipelineMapper.update(null,updateWrapper);
                        // 2.检验信息更新或者插入
                        InspectionDetectionInfo info = new InspectionDetectionInfo();
                        LambdaQueryWrapper<InspectionDetectionInfo> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(InspectionDetectionInfo::getInspectReportNo, model.getResultNo());
                        wrapper.eq(InspectionDetectionInfo::getRecord, record);
                        wrapper.eq(InspectionDetectionInfo::getInspectOrgCode, model.getInspectionUnitCode());
                        List<InspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
                        if (CollectionUtils.isEmpty(list)) {
                            // 无则插入
                            extracted(model, info, jybgFile, record);
                            info.setSequenceNbr(sequence.nextId() + "");
                            inspectionDetectionInfoMapper.insert(info);
                            // 对方不查询库 所以无事务操作
                            bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
                        } else {
                            // 已经维护过则更新
                            info = list.get(0);
                            extracted(model, info, jybgFile, record);
                            inspectionDetectionInfoMapper.updateById(info);
                            // 对方不查询库 所以无事务操作
                            bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
                        }
                        // 3.更新使用信息表，最新检验信息
                        useInfoMapper.updateByRecord(record, model.getNextInspectionDate(), model.getInspectionType(), model.getApplicationNo());
                        // 4.更新es下次检验日期
                        this.updateEquipNextInspectDate(model, record);
                    });
                } catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            // 台套逻辑： 单条更新技术参数、检验信息更新或者插入、使用信息更新(数据库及es)
            // 1.动态更新技术参数
            List<DynamicColumnDto> columns = new ArrayList<>();
            JyjcInspectionResultParam param = iJyjcInspectionResultParamService.getOneParamByResultSeq(model.getSequenceNbr());
            if (param != null) {
                if (!ObjectUtils.isEmpty(param.getParamJson())) {
                    JSONObject paramObj = JSON.parseObject(param.getParamJson());
                    paramObj.forEach((k,v)->{
                            DynamicColumnDto columnDto = new DynamicColumnDto();
                            columnDto.setColumnName(String.format("\"%s\"", StrUtil.toUnderlineCase(k).toUpperCase()));
                            columnDto.setColumnValue(v == null ? null : String.valueOf(v));
                            columns.add(columnDto);
                    });
                    String tableName  = this.getTableName(param.getParamType());
                    jgCommonMapper.updateTechParamDynamic(tableName, model.getEquipUnicode(), columns);
                }
            }
            // 2.检验信息更新或者插入
            InspectionDetectionInfo info = new InspectionDetectionInfo();
            QueryWrapper<InspectionDetectionInfo> wrapper = new QueryWrapper<>();
            wrapper.lambda().eq(InspectionDetectionInfo::getInspectReportNo, model.getResultNo());
            List<InspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
            if (CollectionUtils.isEmpty(list)) {
                extracted(model, info, jybgFile, model.getEquipUnicode());
                info.setSequenceNbr(sequence.nextId() + "");
                inspectionDetectionInfoMapper.insert(info);
                // 对方不查询库 所以无事务操作
                bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
            } else {
                info = list.get(0);
                extracted(model, info, jybgFile, model.getEquipUnicode());
                inspectionDetectionInfoMapper.updateById(info);
                // 对方不查询库 所以无事务操作
                bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
            }
            // 3.更新使用信息表最新的检验信息
            useInfoMapper.updateByRecord(model.getEquipUnicode(), model.getNextInspectionDate(), model.getInspectionType(), model.getApplicationNo());
            // 4.es更新下次检验日期
            this.updateEquipNextInspectDate(model, model.getEquipUnicode());
        }
    }

    private String getTableName(String paramType) {
        return String.format("\"%s\"", StrUtil.toUnderlineCase(paramType));
    }

    private void updateHisDataAfterResultUpdate(JyjcInspectionResultModel model) {
        JyjcInspectionApplication application = inspectionApplicationService.getOne(new LambdaQueryWrapper<JyjcInspectionApplication>().eq(JyjcInspectionApplication::getApplicationNo, model.getApplicationNo()));
        inspectionApplicationService.createHisAfterReceive(BeanUtil.copyProperties(application, JyjcInspectionApplicationModel.class));
    }

    private void updateEquipNextInspectDate(JyjcInspectionResultModel model, String record) {
        if (model.getNextInspectionDate() != null) {
            Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
            if (optional.isPresent()) {
                ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
                esEquipmentCategoryDto.setNEXT_INSPECT_DATE(model.getNextInspectionDate().getTime());
                esEquipmentCategory.save(esEquipmentCategoryDto);
            }
        }
    }

    private void extracted(JyjcInspectionResultModel model, InspectionDetectionInfo info, JyjcInspectionResultAttachment jybgFile, String record) {
        info.setInspectOrgName(model.getInspectionUnitName());
        info.setInspectType(model.getInspectionType());
        info.setRecord(record);
        info.setInspectDate(model.getInspectionDate());
        info.setInspectStaff(getInspectUserName(model));
        info.setInspectStaffCode(model.getInspector());
        info.setInspectReport(jybgFile.getAttachmentUrl());
        info.setInspectConclusion(model.getInspectionConclusion());
        // json字段暂时注释
//        info.setProblemRemark(model.getNonConformance());
        info.setNextInspectDate(model.getNextInspectionDate());
        info.setSequenceCode(record);
        info.setInspectOrgCode(model.getInspectionUnitCode());
        info.setInspectReportNo(model.getResultNo());
        info.setRecDate(new Date());
    }

    private String getInspectUserName(JyjcInspectionResultModel model) {
        List<TzsUserInfo> userInfos = commonService.getUserInfosByUnitCode(model.getInspectionUnitCode());
        return userInfos.stream().filter(u -> model.getInspector().contains(u.getSequenceNbr() + "")).map(TzsUserInfo::getName).collect(Collectors.joining(","));
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultModel> queryForJyjcInspectionResultList() {
        return this.queryForList("", false);
    }

    @Override
    public Map<String, Object> queryDetailBySeq(Long sequenceNbr) {
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>(9);

        JyjcInspectionResultModel jyjcInspectionResultModel = this.queryBySeq(sequenceNbr);
        if (!ObjectUtils.isEmpty(jyjcInspectionResultModel)) {
            // 对象转map
            map = BeanUtil.beanToMap(jyjcInspectionResultModel);

            // 获取附件
            List<JyjcInspectionResultAttachment> attachmentList = iJyjcInspectionResultAttachmentService.getObjByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(attachmentList)) {
                Map<String, Object> attachmentMap = attachmentList.stream().map(obj -> {
                    if (StringUtil.isNotEmpty(obj.getAttachmentUrl())) {
                        obj.setAttachmentUrlList(JSONArray.parseArray(obj.getAttachmentUrl()));
                    }
                    return obj;
                }).collect(Collectors.toMap(JyjcInspectionResultAttachment::getAttachmentType, JyjcInspectionResultAttachment::getAttachmentUrlList));
                map.putAll(attachmentMap);
            }
            // 获取技术参数
            List<JyjcInspectionResultParam> paramList = iJyjcInspectionResultParamService.getParamByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(paramList)) {
                Map<String, Object> finalMap = map;
                paramList.forEach(param -> {
                    if (!ObjectUtils.isEmpty(param.getParamJson())) {
                        JSONObject paramObj = JSON.parseObject(String.valueOf(param.getParamJson()));
                        paramObj.put("equList", finalMap.get("equList"));
                        paramObj.put("equCategory", finalMap.get("equCategory"));
                        paramObj.put("inspectionType", jyjcInspectionResultModel.getInspectionType());
                        resultMap.put(param.getParamType(), paramObj);
                    }
                });
            }
        }
        resultMap.put(JYJC_SUBMIT_KEY, map);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> equipList(String type, String notNode) {
        List<Map<String, Object>> menus = new ArrayList<>();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> mapList;
        if (ValidationUtil.isEmpty(type)) {
            mapList = resourceJson.get(EquipmentClassifityEnum.BDLS.getCode());
        } else {
            mapList = resourceJson.get(type);
        }

        mapList.stream().filter(map -> {
            if (!ObjectUtils.isEmpty(notNode)) {
                String[] code = notNode.split(",");
                List<String> codeList = Arrays.asList(code);
                return !codeList.contains(map.get("code"));
            }
            return true;
        }).forEach(obj -> {
            Map<String, Object> resultMap = new HashMap<>(2);
            resultMap.put("instanceName", obj.get("name"));
            resultMap.put("instanceId", obj.get("code"));
            menus.add(resultMap);
        });

        return menus;
    }

    @Transactional(rollbackFor = Exception.class)
    public List<JyjcInspectionResultDataModel> receivePushResultData(List<JyjcInspectionResultDataModel> resultDataModels) {
        log.info("收到检验检测厂商推送的结果数据：{}", JSONArray.toJSONString(resultDataModels));
        // 1.数据合法性检查
        this.checkMustFieldIsValid(resultDataModels);
        // 2.组织数据
        List<JyjcInspectionResult> resultList = queryResultList(resultDataModels);
        // key为{record}， value为{JyjcInspectionResult}，首次检验时，设备无监管码，用record作为设备标识，可适用与所有的检验结果的接收
        Map<String, JyjcInspectionResult> recordResultMap = getRecordKeyResultMap(resultList);
        // key为{supervisoryCode}， value为{JyjcInspectionResult} ，适用于非首次检验之外的检验结果接收
        Map<String, JyjcInspectionResult> superviseCodeKeyResultMap = getSuperviseCodeKeyResultMap(resultList);
        List<JyjcInspectionResult> updateResultList = new ArrayList<>();
        List<JyjcInspectionResultAttachment> resultAttachments = new ArrayList<>();
        List<JyjcInspectionResultParam> resultParams = new ArrayList<>();
        resultDataModels.forEach(r -> {
            JyjcInspectionResult result = this.getJyjcInspectionResult(r,recordResultMap, superviseCodeKeyResultMap);
            if(result != null) {
                // 填充主表数据
                this.fillResultData(r, result, updateResultList);
                // 填充附件数据
                this.fillResultAttachmentData(r, result, resultAttachments);
                // 填充技术参数数据
                this.fillResultParamData(r, result, resultParams);
            }
        });
        // 3.数据入库
        if(!updateResultList.isEmpty()){
            // 3.1 批量保存主表数据
            this.updateBatchById(updateResultList);
            // 3.2 批量保存子表数据
            deleteAndCreateSubTable(updateResultList, resultAttachments, resultParams);
            // 3.3 异步更新最新一次检验信息
            eventPublisher.publish(new UseInfoSaveToDbEvent(this, new ArrayList<>(updateResultList)));
            // 4.4 异步更新设备的检验检测信息
            eventPublisher.publish(new InspectionDetectionSaveToDbEvent(this, new ArrayList<>(updateResultList)));
        }
        return resultDataModels;
    }

    private void checkMustFieldIsValid(List<JyjcInspectionResultDataModel> resultDataModels) {
        int i = 0;
        for(JyjcInspectionResultDataModel resultDataModel : resultDataModels){
            i++;
            if(StringUtils.isEmpty(resultDataModel.getEquipId()) && StringUtils.isEmpty(resultDataModel.getSupervisoryCode())){
                throw new BadRequest("第" + i + "条数据存在问题，supervisoryCode和equipId不能同时为空！");
            }
        }
    }

    private JyjcInspectionResult getJyjcInspectionResult(JyjcInspectionResultDataModel resultDataModel,
                                                         Map<String, JyjcInspectionResult> recordResultMap ,
                                                         Map<String, JyjcInspectionResult> superviseCodeKeyResultMap){
        if(StringUtils.isNotEmpty(resultDataModel.getEquipId())){
            return recordResultMap.get(resultDataModel.getApplicationNo() + ":" + resultDataModel.getEquipId());
        }
        if(StringUtils.isNotEmpty(resultDataModel.getSupervisoryCode())){
            return superviseCodeKeyResultMap.get(resultDataModel.getApplicationNo() + ":" + resultDataModel.getSupervisoryCode());
        }
        return null;
    }



    private void deleteAndCreateSubTable(List<JyjcInspectionResult> resultList, List<JyjcInspectionResultAttachment> resultAttachments, List<JyjcInspectionResultParam> resultParams) {
        List<Long> resultIds = resultList.stream().map(BaseEntity::getSequenceNbr).collect(Collectors.toList());
        if (!resultAttachments.isEmpty()) {
            attachmentService.remove(new LambdaQueryWrapper<JyjcInspectionResultAttachment>().in(JyjcInspectionResultAttachment::getResultSeq, resultIds));
            attachmentService.saveBatch(resultAttachments);
        }
        if (!resultParams.isEmpty()) {
            resultParamService.remove(new LambdaQueryWrapper<JyjcInspectionResultParam>().in(JyjcInspectionResultParam::getResultSeq, resultIds));
            resultParamService.saveBatch(resultParams);
        }
    }


    private void fillResultParamData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultParam> resultParams) {
        JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
        resultParam.setResultSeq(jyjcInspectionResult.getSequenceNbr());
        resultParam.setParamJson(JSON.toJSONString(r.getTechParams()));
        resultParam.setRecUserId(RequestContext.getExeUserId());
        resultParam.setRecDate(new Date());
        resultParam.setRemark("同步数据");
        // 将设备种类code换成技术参数枚举
        resultParam.setParamType(this.getTypeByEquipList(jyjcInspectionResult.getEquList()));
        resultParams.add(resultParam);
    }

    private String getTypeByEquipList(String equList) {
        EquipCategoryEnum categoryEnum = EquipCategoryEnum.of(Integer.parseInt(equList));
        assert categoryEnum != null;
        // 前端为枚举类名称的驼峰形式且首字母大写，故进行格式转化换
        return StrUtil.upperFirst(StrUtil.toCamelCase(categoryEnum.name()));
    }

    private void fillResultAttachmentData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultAttachment> resultAttachments) {
        r.getAttachments().forEach(a -> {
            JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
            attachment.setResultSeq(jyjcInspectionResult.getSequenceNbr());
            attachment.setAttachmentType(a.getAttachmentType());
            attachment.setAttachmentUrl(JSON.toJSONString(a.getAttachmentContent()));
            attachment.setRecUserId(RequestContext.getExeUserId());
            attachment.setRecDate(new Date());
            attachment.setRemark("同步数据");
            resultAttachments.add(attachment);
        });
    }

    private void fillResultData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResult> updateResultList) {
        jyjcInspectionResult.setResultStatus(ResultStatusEnum.YES_RESULT.getCode());
        jyjcInspectionResult.setLicenseNumber(r.getLicenseNumber());
        jyjcInspectionResult.setResultNo(r.getResultNo());
        jyjcInspectionResult.setInnerPersonCode(r.getInnerPersonCode());
        jyjcInspectionResult.setInspector(this.getUserSeqByPersonCode(r.getInnerPersonCode()));
        jyjcInspectionResult.setInspectionConclusion(r.getInspectionConclusion());
        jyjcInspectionResult.setInspectionDate(r.getInspectionDate());
        jyjcInspectionResult.setNextInspectionDate(r.getNextInspectionDate());
        jyjcInspectionResult.setInspectionStartDate(r.getInspectionStartDate());
        jyjcInspectionResult.setInspectionEndDate(r.getInspectionEndDate());
        jyjcInspectionResult.setInspectionResultSummary(r.getInspectionResultSummary());
        jyjcInspectionResult.setNonConformance(JSON.toJSONString(r.getNonConformance()));
        jyjcInspectionResult.setRemark("同步数据");
        jyjcInspectionResult.setTraceId(r.getTraceId());
        updateResultList.add(jyjcInspectionResult);
    }

    private String getUserSeqByPersonCode(String innerPersonCode) {
        if (StrUtil.isNotEmpty(innerPersonCode)) {
            List<TzsUserInfo> tzsUserInfos = tzsUserInfoMapper.selectList(new LambdaQueryWrapper<TzsUserInfo>().in(TzsUserInfo::getInnerPersonCode, Arrays.asList(innerPersonCode.split(","))));
            return tzsUserInfos.stream().map(u -> u.getSequenceNbr() + "").collect(Collectors.joining(","));
        }
        log.error("检验人员内部编号为空");
        return "";
    }

    private Map<String, JyjcInspectionResult> getSuperviseCodeKeyResultMap(List<JyjcInspectionResult> resultList) {
        return resultList.stream().filter(r-> StringUtils.isNotEmpty(r.getSupervisoryCode())).collect(Collectors.toMap((c) -> c.getApplicationNo() + ":" + c.getSupervisoryCode(), Function.identity()));
    }

    private Map<String, JyjcInspectionResult> getRecordKeyResultMap(List<JyjcInspectionResult> resultList) {
        return resultList.stream().collect(Collectors.toMap((c) -> c.getApplicationNo() + ":" + c.getEquipUnicode(), Function.identity()));
    }

    private List<JyjcInspectionResult> queryResultList(List<JyjcInspectionResultDataModel> resultDataModels) {
        List<String> applicationNos = resultDataModels.stream().map(JyjcInspectionResultDataModel::getApplicationNo).collect(Collectors.toList());
        LambdaQueryWrapper<JyjcInspectionResult> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(JyjcInspectionResult::getApplicationNo, applicationNos);
        return this.list(wrapper);
    }

    public List<DictionarieModel> inspectTypeListByPerson(ReginParams selectedOrgInfo) {
        String group = getPersonIdentityByType(selectedOrgInfo.getCompany().getCompanyType());
        return JyjcInspectionApplicationServiceImpl.getDictionarieModels(group);
    }

    @Async
    public void updatePlanCreateDateByAppNo(String appNo) {
        LambdaUpdateWrapper<JyjcInspectionResult> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(JyjcInspectionResult::getApplicationNo, appNo);
        updateWrapper.set(JyjcInspectionResult::getPlanCreateDate, new Date());
        this.update(updateWrapper);
    }

    /**
     * 检验检测结果列表数据导出
     * @param response
     * @param ids
     */
    public void Export(HttpServletResponse response, List<String> ids) {
        List<JyjcInspectionResultVo> exportData = this.baseMapper.queryExportInIds(ids);
        for (JyjcInspectionResultVo vo : exportData) {
            if (vo.getResultStatus().equals("1")) {
                vo.setResultStatus("未出");
            } else if (vo.getResultStatus().equals("2")) {
                vo.setResultStatus("已出");
            }
        }
        ExcelUtil.createTemplate(response, "检验检测结果列表数据", "检验检测结果列表", exportData, JyjcInspectionResultVo.class, null, false);
    }
}