package com.yeejoin.amos.api.openapi.dto;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;

/**
 * 测试报检基础数据
 */
@Data
public class InspectMockAppData {

    @NotBlank(message = "设备种类代码不能为空")
    private String equList;

    @NotBlank(message = "设备类别代码不能为空")
    private String equCategory;

    private String equDefine;

    @NotBlank(message = "检验检测类型不能为空")
    private String inspectType;

    @NotBlank(message = "报检单位代码不能为空")
    private String applicationUnitCode;

    @NotBlank(message = "报检单位名称不能为空")
    private String applicationUnitName;

    @NotBlank(message = "检验机构信用代码不能为空")
    private String inspectionUnitCode;

    @NotBlank(message = "检验机构名称不能为空")
    private String inspectionUnitName;


    @NotBlank(message = "申请联系人")
    private String applicationContactName;


    @NotBlank(message = "申请联系人电话")
    private String applicationContactPhone;

    @NotBlank(message = "对接唯一标识")
    private String appId;

    @Min(value = 1, message = "最少申请1个设备报检")
    @Max(value = 10, message = "最少申请10个设备报检")
    private Integer size;
}
