package com.yeejoin.amos.boot.module.tcm.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 警情查询DTO
 */
@Data
@ApiModel(value="AlertCalledDto", description="警情接警填报记录")
public class AlertCalledQueryDto {

   @ExcelIgnore
   private static final long serialVersionUID = 1L;

   @ExcelProperty(value = "工单编号", index = 0)
   @ApiModelProperty(value = "工单编号")
   private String workOrderNumber;

   @ExcelProperty(value = "接警人", index = 1)
   @ApiModelProperty(value = "接警人")
   private String creator;

   @ExcelProperty(value = "求援人", index = 2)
   @ApiModelProperty(value = "求援人")
   private String emergency;

   @ExcelProperty(value = "求援时间", index = 3)
   @ApiModelProperty(value = "求援时间")
   private Date callTime;

   @ExcelIgnore
   @ApiModelProperty(value = "求援时间开始")
   private String emergencyTimeStart;

   @ExcelIgnore
   @ApiModelProperty(value = "求援时间结束")
   private String emergencyTimeEnd;

   @ExcelProperty(value = "求援电话", index = 4)
   @ApiModelProperty(value = "求援电话")
   private String emergencyCall;

   @ExcelProperty(value = "电梯识别码", index = 5)
   @ApiModelProperty(value = "电梯识别码")
   private String deviceId;

   @ExcelProperty(value = "电梯地址", index = 6)
   @ApiModelProperty(value = "电梯地址")
   private String elevatorAddress;

   @ExcelProperty(value = "所属区域", index = 7)
   @ApiModelProperty(value = "所属区域")
   private String district;

   @ExcelIgnore
   @ApiModelProperty(value = "市+区")
   private String address;

   @ExcelProperty(value = "警情类型", index = 8)
   @ApiModelProperty(value = "警情类型")
   private String alertType;

   @ExcelProperty(value = "警情来源", index = 9)
   @ApiModelProperty(value = "警情来源")
   private String alertSource;

   @ExcelProperty(value = "处置环节", index = 10)
   @ApiModelProperty(value = "处置环节")
   private String alertStage;

   @ExcelProperty(value = "完成状态", index = 11)
   @ApiModelProperty(value = "完成状态")
   private String alertStatus;

   @ExcelIgnore
   @ApiModelProperty(value = "页码")
   private Integer pageNum;

   @ExcelIgnore
   @ApiModelProperty(value = "条数")
   private Integer pageSize;

   @ExcelIgnore
   @ApiModelProperty(value = "ID")
   private Long sequenceNbr;

}
