package com.yeejoin.amos.boot.module.ymt.api.enums;

/**
 * 
 * <pre>
 * 电梯运行模式枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftServiceModelEnum.java, v 0.1 2021年9月29日 上午9:24:15 gwb Exp $
 */
public enum LiftServiceModelEnum{

	STOP_SERVICE(1,"停止服务"),
	NORMAL_OPERATION(2,"正常运行"),
	OVERHAUL(3,"检修"),
	FIRE_RETURN(4,"消防返回"),
	FIREFIGHTER_OPERATION(5,"消防员运行"),
	EMERGENCY_POWER_OPERATION(6,"应急电源运行"),
	SEISMIC_MODEL(7,"地震模式"),
	UNKNOWN (8,"未知");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftServiceModelEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftServiceModelEnum getEnum(Integer code)
	{
		for (LiftServiceModelEnum liftCircuitStatusEnum : LiftServiceModelEnum.values())
		{
			if (liftCircuitStatusEnum.getCode().equals(code))
			{
				return liftCircuitStatusEnum;
			}
		}
		return null;
	}
}
