package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.mapper.CustomBaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipWaitRefreshDataQualityScore;
import com.yeejoin.amos.boot.module.ymt.api.dto.RefreshDataDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgOtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 使用信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-08-16
 */
public interface IdxBizJgUseInfoMapper extends CustomBaseMapper<IdxBizJgUseInfo> {
    void batchUpdateUseInfo(@Param("records") List<String> records, Integer code);

    List<IdxBizJgUseInfo> selectXAList();

    List<RefreshDataDto> selectUseInfoOfOneVersion(@Param("version") Integer version);

    List<String> selectUseInfoOfOneVersionAll(@Param("version") Integer version);

    Integer selectMaxVersion();

    void updateDataQualityScoreBatch(@Param("equips") List<EquipWaitRefreshDataQualityScore> refreshDataQualityScores, @Param("version") int version);

    void updateVersionBatch(@Param("records") List<String> records, @Param("version") int version);

    Map<String,Object> queryDetail(@Param("record") String record);

    List<Map<String,Object>> queryDetailBatch(@Param("records") List<String> records);

    Page<String> selectAddDataRecords(Page<String> page);

    Integer selectAddDataRecordsCount();

    Integer selectPiPeCount();

    Page<String> selectPiPeRecords(Page<String> page);

    JSONObject getUsePlaceAndCodeByRecord(@Param("record") String record);

    List<Map<String, Object>> queryBaseInfoByIds(@Param("records") List<String> records);

    List<IdxBizJgOtherInfo> selectOneMockRecord(@Param("equList") String equList, @Param("equCategory") String equCategory, @Param("equDefine") String equDefine, @Param("useUnitCode") String useUnitCode, @Param("size") Integer size);
}
