package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 电站审核状态
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum PowerStationProcessStateEnum {
    进行中("进行中", "0", "progress"),
    通过("通过", "1", "0"),
    不通过("不通过", "2", "1"),
    完成("完成", "3", "complete"),
    作废("作废", "4", "reject");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 编码
     */
    private String describe;

    public static PowerStationProcessStateEnum getStateByResult(String code) {
        PowerStationProcessStateEnum powerStationProcessStateEnum = null;
        for(PowerStationProcessStateEnum type: PowerStationProcessStateEnum.values()) {
            if (type.getDescribe().equals(code)) {
                powerStationProcessStateEnum = type;
                break;
            }
        }
        return powerStationProcessStateEnum;
    }

}
