package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationUnitEqServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationUnitEqDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 单位变更登记设备关系表
 *
 * @author system_generator
 * @date 2023-12-22
 */
@RestController
@Api(tags = "单位变更登记设备关系表Api")
@RequestMapping(value = "/jg-change-registration-unit-eq")
public class JgChangeRegistrationUnitEqController extends BaseController {

    @Autowired
    JgChangeRegistrationUnitEqServiceImpl jgChangeRegistrationUnitEqServiceImpl;

    /**
     * 新增单位变更登记设备关系表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增单位变更登记设备关系表", notes = "新增单位变更登记设备关系表")
	public ResponseModel<JgChangeRegistrationUnitEqDto> save(@RequestBody JgChangeRegistrationUnitEqDto model) {
	    model = jgChangeRegistrationUnitEqServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新单位变更登记设备关系表", notes = "根据sequenceNbr更新单位变更登记设备关系表")
	public ResponseModel<JgChangeRegistrationUnitEqDto> updateBySequenceNbrJgChangeRegistrationUnitEq(@RequestBody JgChangeRegistrationUnitEqDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgChangeRegistrationUnitEqServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除单位变更登记设备关系表", notes = "根据sequenceNbr删除单位变更登记设备关系表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgChangeRegistrationUnitEqServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个单位变更登记设备关系表",  notes = "根据sequenceNbr查询单个单位变更登记设备关系表")
	public ResponseModel<JgChangeRegistrationUnitEqDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgChangeRegistrationUnitEqServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "单位变更登记设备关系表分页查询",  notes = "单位变更登记设备关系表分页查询")
	public ResponseModel<Page<JgChangeRegistrationUnitEqDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgChangeRegistrationUnitEqDto> page = new Page<JgChangeRegistrationUnitEqDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgChangeRegistrationUnitEqServiceImpl.queryForJgChangeRegistrationUnitEqPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "单位变更登记设备关系表列表全部数据查询",   notes = "单位变更登记设备关系表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgChangeRegistrationUnitEqDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgChangeRegistrationUnitEqServiceImpl.queryForJgChangeRegistrationUnitEqList());
	}
}
