package com.yeejoin.amos.boot.module.statistics.api.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.yeejoin.amos.boot.module.common.api.converter.CommonCustomConverter;
import com.yeejoin.amos.boot.module.common.api.converter.PersonFieldCustomConverter;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 人员
 */
@Data
@HeadRowHeight(35)// 标题行高度
@ContentRowHeight(15)// 内容行高度
@ColumnWidth(30)// 默认列宽
public class PersonVo implements Serializable {

    // --------------------------  基本信息 -------------------------------
    @ExcelProperty("姓名")
    private String name;

    @ExcelProperty(value = "证件类型", converter = PersonFieldCustomConverter.CertificateTypeConverter.class)
    private String certificateType;

    @ExcelProperty("证件编号")
    private String certificateNum;

    @ExcelProperty(value = "性别", converter = PersonFieldCustomConverter.GenderConverter.class)
    private String gender;

    @ExcelProperty("单位名称")
    private String unitName;

    @ExcelProperty("企业编码")
    private String unitCode;

    @ExcelProperty("岗位名称")
    private String postName;

    @ExcelProperty("联系电话")
    private String phone;

    @ExcelProperty(value = "出生日期", converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date birthday;

    @ExcelProperty(value = "学历", converter = PersonFieldCustomConverter.EducationConverter.class)
    private String education;

    @ExcelProperty("专业")
    private String speciality;

    @ExcelProperty("邮箱")
    private String email;

    @ExcelProperty("住址")
    private String address;

    @ExcelProperty("人员所属企业单位类型")
    @ColumnWidth(60)
    private String unitType;

    @ExcelProperty("设备类型")
    private String equipType;

    @ExcelProperty("职称")
    private String jobTitle;

    @ExcelProperty("岗位子类型")
    private String subPostName;

    @ExcelProperty("管辖机构名称")
    private String superviseOrgName;

    @ExcelProperty(value = "创建时间", converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date createDate;

    // ------------------------------------- 资质 ------------------------------------

    @ExcelProperty(value = {"资质信息", "检验检测-级别"})
    private String permissionLevel;

    @ExcelProperty(value = {"资质信息", "检验检测-资质项目"})
    private String permissionItem;

    @ExcelProperty(value = {"资质信息", "证书编号"})
    private String certNo;

    @ExcelProperty(value = {"资质信息", "有效期至"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date expiryDate;

    @ExcelProperty(value = {"资质信息", "发证机关"})
    private String approvedOrgan;

    @ExcelProperty(value = {"资质信息", "发证日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date issueDate;

    @ExcelProperty(value = {"资质信息", "证书类型"})
    private String certType;

    @ExcelProperty(value = {"资质信息", "作业项目"})
    private String jobItem;

    @ExcelProperty(value = {"资质信息", "项目代号"})
    private String itemCode;

    @ExcelProperty(value = {"资质信息", "其他作业项目"})
    private String otherItem;
}

 