package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 申请单枚举
 *
 * @author LiuLin
 */

@Getter
@AllArgsConstructor
public enum ApplicationFormTypeEnum {
    /**
     * 申请单枚举
     */
    AZGZ("AZGZ", "GZ_AZ"),//安装告知
    WBBA("WBBA", "WB_BA"),//维保合同备案
    SYDJ("SYDJ", "DJ_SY"),//使用登记
    BZDJ("BZDJ", "DJ_BZ"),// 补证登记
    SBYJ("SBYJ", "SB_YJ"),//设备移交
    GZGZ("GZGZ", "GZ_GZ"),//改造告知
    WXGZ("WXGZ", "GZ_WX"),//维修告知
    YZGZ("YZGZ", "GZ_YZ"),//移装告知
    GZBG("GZBG", "DJ_GZ"),//改造变更登记
    YZBG("YZBG", "DJ_YZ"),//移装变更登记
    DWBG("DWBG", "DJ_DW"),//单位变更登记
    JY("JY", ""),
    JG("SE", ""),// 检验结果
    ZX("ZX", "BF_YZ"),//电梯（设备）移装注销
    BF("BF", "BF_ZX"),//电梯（设备）报废注销
    GMBG("GMBG", "DJ_GM"),//更名变更
    SBQY("SBQY", "SB_QY"),//设备启用
    CSJ("CSJ", "DJ_CSJ"),//超设计年限
    SBTY("SBTY", "SB_TY");//设备启用

    /**
     * 编号
     */
    private final String code;

    /**
     * 业务编号
     */
    private final String businessCode;

    public static Map<String, String> getBusinessCode = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();

    static {
        for (ApplicationFormTypeEnum e : ApplicationFormTypeEnum.values()) {
            getBusinessCode.put(e.code, e.businessCode);
            getCode.put(e.businessCode, e.code);
        }
    }


}
