package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.service.SSOServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.Map;

@RestController
@RequestMapping(value = "/sso")
@Api(tags = "统一门户sso")
public class SSOController {

	@Autowired
	private SSOServiceImpl ssoService;

	/**
	 * 用统一门户code换取access_token
	 *
	 * @return access_token
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@RequestMapping(value = "/{code}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "code换取access_token", notes = "code换取access_token")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<Map<String, String>> getAccessToken(@PathVariable("code") String code) {
		return ResponseHelper.buildResponse(ssoService.getPlatformUserInfo(code));
	}

}
