package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialBoilerModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialPresContainerModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SpecialPresContainerMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SpecialPresContainer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 压力容器 服务类
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@Component
public class SpecialPresContainerService
                extends BaseService<SpecialPresContainerModel, SpecialPresContainer, SpecialPresContainerMapper> {

        /**
         * 分页查询
         */
        public Page<SpecialPresContainerModel> queryForTmSpecialPresContainerPage(Page page, String agencyCode) {
                return this.queryForPage(page, null, false, agencyCode);
        }

        /**
         * 列表查询 示例
         */
        public List<SpecialPresContainerModel> queryForTmSpecialPresContainerList(String agencyCode) {
                return this.queryForList("", false, agencyCode);
        }

		public String createSpecialPresContainer(List<SpecialPresContainerModel> model) {
			// TODO Auto-generated method stub
			if (ValidationUtil.isEmpty(model))
				throw new BadRequest("压力容器信息数据为空.");
	    	
			for (SpecialPresContainerModel specialPresContainerModel : model) {
				specialPresContainerModel.setRecDate(new Date());
				specialPresContainerModel.setAppId(getAppId());
				this.createWithModel(specialPresContainerModel);
			}
			return "OK";
		}
		private String getAppId() {
			String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
	    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
	    	return bizTokenModel.getAppId();
		}
	    @Autowired
	    private RedisTemplate redisTemplate;
}
