package com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.module.jg.api.annotation.DictCode2DictName;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import lombok.Data;

/**
 * 已纳管设备
 */
@Data
public class ManageEquipmentVo {

    @ExcelProperty(value = "设备种类")
    @DictCode2DictName(typeHandler = "equipCategoryDictTypeHandler")
    String equList;

    @ExcelProperty(value = "设备类别")
    @DictCode2DictName(typeHandler = "equipCategoryDictTypeHandler")
    String equCategory;

    @ExcelProperty(value = "设备品种")
    @DictCode2DictName(typeHandler = "equipCategoryDictTypeHandler")
    String equDefine;

    @ExcelProperty(value = "96333识别码")
    String code96333;

    @ExcelProperty(value = "监管码")
    String supervisoryCode;

    @ExcelProperty(value = "使用登记证编号")
    String useRegistrationCode;

    @ExcelProperty(value = "出厂编号/产品编号")
    String factoryNum;

    @ExcelProperty(value = "设备代码")
    String equCode;

    @ExcelProperty(value = "设备状态")
    @DictCode2DictName(type = "SHZT", typeHandler = "cbDataDictTypeHandler")
    String equState;

    @ExcelProperty(value = "设备总价值（万元）")
    String equPrice;

    @ExcelProperty(value = "设备单位内编号")
    String useInnerCode;

//    @ExcelProperty(value = "总图图号")
//    String drawingDo;

    @ExcelProperty(value = "设备型号")
    String equType;

    @ExcelProperty(value = "管道名称")
    String productName;

    @ExcelProperty(value = "设备使用地点省")
    String provinceName;

    @ExcelProperty(value = "设备使用地点市")
    String cityName;

    @ExcelProperty(value = "设备使用地点区(县)")
    String countyName;

//    @ExcelProperty(value = "设备使用地点街道(镇)")
//    String factoryUseSiteStreet;

    @ExcelProperty(value = "设备详细使用地点")
    String fullAddress;

    @ExcelProperty(value = "设备使用场所")
    @DictCode2DictName(type = "ADDRESS", typeHandler = "cbDataDictTypeHandler")
    String usePlace;

    @ExcelProperty(value = "产权单位社会信用代码")
    String estateUnitCreditCode;

    @ExcelProperty(value = "产权单位名称")
    String estateUnitName;

//    @ExcelProperty(value = "工程（装置）名称")
//    String projectContraption;

    @ExcelProperty(value = "车辆VIN码（车架号）")
    String identificationCode;

    @ExcelProperty(value = "车牌号")
    String carNumber;

    @ExcelProperty(value = "属地监管部门")
    String orgBranchName;

    @ExcelProperty(value = "使用单位统一社会信用代码")
    String useUnitCreditCode;

    @ExcelProperty(value = "使用单位")
    String useUnitName;

    @ExcelProperty(value = "信息化管理情况")
    String informationSituation;

    @ExcelProperty(value = "检验/检测机构统一代码")
    String inspectOrgCode;

    @ExcelProperty(value = "检验/检测机构名称")
    String inspectOrgName;

    @ExcelProperty(value = "检验报告编号")
    String inspectReportNo;

    @ExcelProperty(value = "检验/检测结论")
    @DictCode2DictName(type = "JYJL", typeHandler = "cbDataDictTypeHandler")
    String inspectConclusion;

    @ExcelProperty(value = "检验/检测类型")
    @DictCode2DictName(type = "JYJC", typeHandler = "cbDataDictTypeHandler")
    String inspectType;

    @ExcelProperty(value = "检验/检测人员名称")
    String inspectStaff;

    @ExcelProperty(value = "检验/检测日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String inspectDate;

    @ExcelProperty(value = "下次检验/检测日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String nextInspectDate;

    @ExcelProperty(value = "制造单位统一社会信用代码")
    String produceUnitCreditCode;

    @ExcelProperty(value = "制造单位名称")
    String produceUnitName;

    @ExcelProperty(value = "制造许可编号")
    String produceLicenseNum;

    @ExcelProperty(value = "制造日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String produceDate;

    @ExcelProperty(value = "制造国")
    String produceCountry;

//    @ExcelProperty(value = "制造标准")
//    String factoryStandard;

    @ExcelProperty(value = "设计单位统一社会信用代码")
    String designUnitCreditCode;

    @ExcelProperty(value = "设计单位名称")
    String designUnitName;

    @ExcelProperty(value = "设计许可编号")
    String designLicenseNum;

    @ExcelProperty(value = "设计使用年限")
    String designUseDate;

    @ExcelProperty(value = "设计文件鉴定单位")
    String appraisalUnit;

    @ExcelProperty(value = "设计日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String designDate;

    @ExcelProperty(value = "设计文件鉴定日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String appraisalDate;

    @ExcelProperty(value = "安装单位")
    String installPropertyUnitName;

    @ExcelProperty(value = "安装负责人")
    String installLeaderName;

    @ExcelProperty(value = "安全管理员联系电话")
    String phone;

    @ExcelProperty(value = "安装地点")
    String installAddress;

    @ExcelProperty(value = "安装日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String installStartDate;


    @ExcelProperty(value = "维保单位")
    String meUnitName;

//    @ExcelProperty(value = "安装及使用维护保养说明")
//    String insUseMaintainExplain;

    @ExcelProperty(value = "施工区域-省")
    String installProvince;

    @ExcelProperty(value = "施工区域-市")
    String installCity;

    @ExcelProperty(value = "施工区域-区/县")
    String installCounty;

    @ExcelProperty(value = "安全管理员")
    String safetyManager;

    @ExcelProperty(value = "安装负责人联系电话")
    String installLeaderPhone;

    @ExcelProperty(value = "维保合同开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String informStart;

    @ExcelProperty(value = "维保合同结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String informEnd;

    @ExcelProperty(value = "维保人员一")
    String meMaster;

    @ExcelProperty(value = "维保人员一联系方式")
    String meMasterPhone;

    @ExcelProperty(value = "维保人员二")
    String meMaster1;

    @ExcelProperty(value = "维保人员二联系方式")
    String meMaster1Phone;

    @ExcelProperty(value = "备注")
    String informationManageCode;

    @ExcelProperty(value = "门数")
    String numberDoors;

    @ExcelProperty(value = "控制方式")
    @DictCode2DictName(type = "KZFS", typeHandler = "cbDataDictTypeHandler")
    String controlMode;

    @ExcelProperty(value = "倾斜角")
    String angleRoll;

    @ExcelProperty(value = "提升高度")
    String liftingHeight;

    @ExcelProperty(value = "整机防爆标志")
    String explosionproofSignComplete;

    @ExcelProperty(value = "区域防爆等级")
    @DictCode2DictName(type = "FBDJ", typeHandler = "cbDataDictTypeHandler")
    String explosionproofGrade;

    @ExcelProperty(value = "额定速度")
    String ratedSpeed;

    @ExcelProperty(value = "层数")
    String storey;

    @ExcelProperty(value = "顶升方式")
    @DictCode2DictName(type = "DSXS", typeHandler = "cbDataDictTypeHandler")
    String jackingType;

    @ExcelProperty(value = "额定载重量")
    String ratedLoadCapacity;

    @ExcelProperty(value = "名义速度")
    String nominalSpeed;

    @ExcelProperty(value = "额定速度(下行)")
    String ratedSpeedDown;

    @ExcelProperty(value = "名义宽度")
    String nominalWidth;

    @ExcelProperty(value = "油缸数量")
    String numberCylinders;

    @ExcelProperty(value = "轿门位置")
    String doorPosition;

    @ExcelProperty(value = "输送能力")
    String conveyingCapacity;

    @ExcelProperty(value = "站数")
    String stand;

    @ExcelProperty(value = "额定速度(上行)")
    String ratedSpeedUp;

    @ExcelProperty(value = "使用区段长度")
    String useSectionLength;

    @ExcelProperty(value = "大车运行速度")
    String bigcarRunSpeed;

    @ExcelProperty(value = "小车运行速度")
    String smallcarrunSpeed;

    @ExcelProperty(value = "工作幅度")
    String spanWorkingRange;

    @ExcelProperty(value = "起升速度")
    String liftingSpeed;

    @ExcelProperty(value = "吊笼工作行程")
    String workStrokeCage;

    @ExcelProperty(value = "层数")
    String numberStorey;

    @ExcelProperty(value = "悬臂长度")
    String cantileverLength;

    @ExcelProperty(value = "额定起重量")
    String ratedLiftingCapacity;

    @ExcelProperty(value = "最大起重量")
    String maxLiftingCapacity;

    @ExcelProperty(value = "适停车辆尺寸（长）")
    String parkingVehicleLength;

    @ExcelProperty(value = "额定提升速度")
    String ratedLiftingSpeed;

    @ExcelProperty(value = "自由端高度")
    String heightFreeEnd;

    @ExcelProperty(value = "单车最大（进）时间")
    String bicycleMaxComeTime;

    @ExcelProperty(value = "单车最大（出）时间")
    String bicycleMaxExitTime;

    @ExcelProperty(value = "额定起重力矩")
    String ratedLiftingTorque;

    @ExcelProperty(value = "监检结束时高度")
    String checkFinishedHeight;

    @ExcelProperty(value = "吊笼数量")
    String hangingCagesNumber;

    @ExcelProperty(value = "横移速度")
    String ratedTraverseSpeed;

    @ExcelProperty(value = "工作级别")
    @DictCode2DictName(type = "GZJB", typeHandler = "cbDataDictTypeHandler")
    String workLevel;

    @ExcelProperty(value = "运行速度")
    String runningSpeed;

    @ExcelProperty(value = "起升高度")
    String liftingHeight1;

    @ExcelProperty(value = "适停车辆尺寸（宽）")
    String parkingVehicleWeight;

    @ExcelProperty(value = "整机防爆标志")
    String explosionproofSignComplete1;

    @ExcelProperty(value = "最大起重力矩")
    String maxLiftingTorque;

    @ExcelProperty(value = "燃爆物质")
    String explosiveSubstance;

    @ExcelProperty(value = "存容量")
    String storageCapacity;

    @ExcelProperty(value = "升降速度")
    String ratedLiftSpeed;

    @ExcelProperty(value = "适停车辆尺寸（高）")
    String parkingVehicleHeight;

    @ExcelProperty(value = "额定载重量")
    String ratedLoadCapacity1;

    @ExcelProperty(value = "额定乘员数")
    String ratedMembers;

    @ExcelProperty(value = "监检结束高度")
    String checkFinshedHeight;

    @ExcelProperty(value = "区域防爆等级")
    @DictCode2DictName(type = "FBDJ", typeHandler = "cbDataDictTypeHandler")
    String explosionProofGrade;

    @ExcelProperty(value = "变幅速度")
    String derrickingSpeed;


    @ExcelProperty(value = "车架（底盘）编号")
    String frameNo;

    @ExcelProperty(value = "发动机（行走电机）编号")
    String engineNo;

    @ExcelProperty(value = "额定起重量")
    String liftingCapacity;

    @ExcelProperty(value = "观光列车牵引车头座位数")
    String tractorSeatNumber;

    @ExcelProperty(value = "轴距")
    String wheelBase;

    @ExcelProperty(value = "传动方式")
    String transmissionMode;

    @ExcelProperty(value = "自重")
    String weight;

    @ExcelProperty(value = "车架结构")
    String frameStructure;

    @ExcelProperty(value = "空载最大起升高度")
    String maxLiftingHeight;

    @ExcelProperty(value = "额定载客人数")
    String passengersNumber;

    @ExcelProperty(value = "最大行驶坡度")
    String maxDrivingSlope;

    @ExcelProperty(value = "观光列车车厢数")
    String carsNumber;

    @ExcelProperty(value = "观光列车每节车厢座位数")
    String seatNumber;

    @ExcelProperty(value = "防爆设备保护级别")
    @DictCode2DictName(type = "FBDJ", typeHandler = "cbDataDictTypeHandler")
    String protectGrade;

    @ExcelProperty(value = "驾驶方式")
    String drivingMode;

    @ExcelProperty(value = "轮距（后）")
    String trackWidthBehind;

    @ExcelProperty(value = "整车整备质量")
    String vehicleMass;

    @ExcelProperty(value = "动力方式")
    String powerMode;

    @ExcelProperty(value = "防爆气体/粉尘组别")
    String gasGroup;

    @ExcelProperty(value = "空载最大运行速度")
    String carryingIdlerMaxRunningSpeed;

    @ExcelProperty(value = "轮距（前）")
    String trackWidthFront;

    @ExcelProperty(value = "最大运行速度")
    String maxRunningSpeed;

    @ExcelProperty(value = "防爆温度组别")
    String temperatureGroup;

    @ExcelProperty(value = "锅炉本体水(油)容积")
    String waterOilVolumeOfBoilerProper;

    @ExcelProperty(value = "再热器进(出)口压力")
    String reheaterInletOutletPressure;

    @ExcelProperty(value = "水（耐）压试验压力")
    String hydrostaticTestPressure;

    @ExcelProperty(value = "无损检测比例")
    String proportionOfNdtForPressureParts;

    @ExcelProperty(value = "水（耐）压试验介质")
    String hydrostaticTestMedium;

    @ExcelProperty(value = "额定工作压力")
    String ratedWorkingPressure;

    @ExcelProperty(value = "有机热载体锅炉气密试验介质/压力")
    String glAirtightTest;

    @ExcelProperty(value = "给水温度")
    String feedwaterTemperature;

    @ExcelProperty(value = "主要受压力部件名称")
    @DictCode2DictName(type = "GLBJMC", typeHandler = "cbDataDictTypeHandler")
    String nameOfPressureParts;

    @ExcelProperty(value = "热处理时间")
    String heatTreatmentTimeOfPressureParts;

    @ExcelProperty(value = "燃烧方式")
    String combustionMode;

    @ExcelProperty(value = "再热蒸汽流量")
    String reheatSteamFlow;

    @ExcelProperty(value = "热处理温度")
    String heatTreatmentTemperatureOfPressureParts;

    @ExcelProperty(value = "整装锅炉本体液压试验介质/压力")
    String hydraulicTestMediumPressureOfPackagedBoilerBody;

    @ExcelProperty(value = "额定蒸发量(热功率)")
    String ratedEvaporationCapacityThermalPower;

    @ExcelProperty(value = "燃料（热源）种类")
    @DictCode2DictName(type = "GLZL", typeHandler = "cbDataDictTypeHandler")
    String fuelType;

    @ExcelProperty(value = "壁厚")
    String wallThicknessOfPressureParts;

    @ExcelProperty(value = "额定出/回水(油)温度")
    String ratedOutletReturnWaterOilTemperature;

    @ExcelProperty(value = "材料")
    String materialOfPressureParts;

    @ExcelProperty(value = "设备级别")
    @DictCode2DictName(type = "GLJB", typeHandler = "cbDataDictTypeHandler")
    String deviceLevel;

    @ExcelProperty(value = "设计热效率")
    String designThermalEfficiency;

    @ExcelProperty(value = "额定工作温度")
    String ratedOperatingTemperature;

    @ExcelProperty(value = "再热器进(出)口温度")
    String inletOutletTemperatureOfReheater;

    @ExcelProperty(value = "容器型号")
    String container;

    @ExcelProperty(value = "厚度（衬里）")
    String fixedLining;

    @ExcelProperty(value = "厚度（筒体(球壳)）")
    String thickness;

    @ExcelProperty(value = "厚度（夹套）")
    String fixedJacket;

    @ExcelProperty(value = "设计温度（夹套）")
    String temperatureJacket;

    @ExcelProperty(value = "最高允许工作压力（管程）")
    String maxPressurePipe;

    @ExcelProperty(value = "材料（夹套）")
    String materialJacket;

    @ExcelProperty(value = "压力")
    String chamberPressure;

    @ExcelProperty(value = "设计温度（管程）")
    String temperaturePipe;

    @ExcelProperty(value = "设计压力")
    String designPressure;

    @ExcelProperty(value = "容器自重")
    String selfWeight;

    @ExcelProperty(value = "盛装介质重量")
    String mediumWeight;

    @ExcelProperty(value = "主体结构")
    String chamberMain;

    @ExcelProperty(value = "充装介质")
    @DictCode2DictName(type = "FILLING_MEDIUM", typeHandler = "platformDictTypeHandler")
    String chargingMedium;

    @ExcelProperty(value = "材料（筒体）")
    String materialCylinder;

    @ExcelProperty(value = "容器容积")
    String containerVolume;

    @ExcelProperty(value = "材料（瓶体）")
    String bottleBody;

    @ExcelProperty(value = "瓶体内含氧量")
    String oxygen;

    @ExcelProperty(value = "无损检测方法（管路）")
    @DictCode2DictName(type = "RQJCFF", typeHandler = "cbDataDictTypeHandler")
    String glLossless;

    @ExcelProperty(value = "气瓶安装位置")
    String installationPosition;

    @ExcelProperty(value = "容器高(长)")
    String height;

    @ExcelProperty(value = "人均舱容")
    String perCapitaCabinCapacity;

    @ExcelProperty(value = "最高允许工作压力（壳程）")
    String maxPressureShell;

    @ExcelProperty(value = "设计温度（壳程）")
    String temperatureShell;

    @ExcelProperty(value = "耐压试验压力（气瓶）")
    String qpPressure;

    @ExcelProperty(value = "主体结构型式")
    @DictCode2DictName(type = "RQJG", typeHandler = "cbDataDictTypeHandler")
    String mainStructureType;

    @ExcelProperty(value = "泄漏试验压力")
    String leakPressure;

    @ExcelProperty(value = "设计压力（夹套）")
    String pressureJacket;

    @ExcelProperty(value = "压力介质")
    String pressureMedium;

    @ExcelProperty(value = "保温绝热方式")
    String insulation;

    @ExcelProperty(value = "材料（筒体(球壳)）")
    String materialCylinderShell;

    @ExcelProperty(value = "公称工作压力")
    String nominalWorkingPressure;

    @ExcelProperty(value = "容积")
    String volume;

    @ExcelProperty(value = "气体置换后压力")
    String displacementPressure;

    @ExcelProperty(value = "容器内径")
    String pressureVesselDiameter;

    @ExcelProperty(value = "无损检测方法（气瓶）")
    @DictCode2DictName(type = "RQJCFF", typeHandler = "cbDataDictTypeHandler")
    String qpLossless;

    @ExcelProperty(value = "介质（管程）")
    String mediumPipe;

    @ExcelProperty(value = "无损检测比例（管路）")
    String glRatio;

    @ExcelProperty(value = "材料（端塞）")
    String endPlug;

    @ExcelProperty(value = "支座型式")
    String support;

    @ExcelProperty(value = "泄漏试验种类")
    String leakage;

    @ExcelProperty(value = "设计温度")
    String designTemperature;

    @ExcelProperty(value = "介质")
    String medium;

    @ExcelProperty(value = "耐压试验压力")
    String withstandPressureTest;

    @ExcelProperty(value = "热处理方式")
    String heatTreatmentMethod;

    @ExcelProperty(value = "最大充装量")
    String maxFill;

    @ExcelProperty(value = "外径")
    String outsideDiameter;

    @ExcelProperty(value = "气密性试验压力（管路）")
    String glAirTightness;

    @ExcelProperty(value = "额定质量")
    String ratedQuality;

    @ExcelProperty(value = "介质（壳程）")
    String mediumShell;

    @ExcelProperty(value = "安装型式")
    String installation;

    @ExcelProperty(value = "壁厚")
    String wallThickness;

    @ExcelProperty(value = "温度")
    String temperature;

    @ExcelProperty(value = "无损检测比例（气瓶）")
    String qpRatio;

    @ExcelProperty(value = "气密性试验压力（气瓶）")
    String qpAirTightness;

    @ExcelProperty(value = "氧舱品种")
    String oxygenChamber;

    @ExcelProperty(value = "无损检测方法")
    @DictCode2DictName(type = "RQJCFF", typeHandler = "cbDataDictTypeHandler")
    String checkLossless;

    @ExcelProperty(value = "长度")
    String length;

    @ExcelProperty(value = "规格")
    String specification;

    @ExcelProperty(value = "罐车编号")
    String carNum;

    @ExcelProperty(value = "设计压力（壳程）")
    String pressureHousingPath;

    @ExcelProperty(value = "额定进舱人数")
    String ratedEntryCapacity;

    @ExcelProperty(value = "使用环境温度")
    String ambientTemperature;

    @ExcelProperty(value = "最高允许工作压力（夹套）")
    String maxPressureJacket;

    @ExcelProperty(value = "材料（管路）")
    String piping;

    @ExcelProperty(value = "材料（衬里）")
    String pressureMaterialLining;

    @ExcelProperty(value = "热处理温度")
    String qpHeatTreatmentTemperature;

    @ExcelProperty(value = "材料（封头）")
    String pressureMaterialHead;

    @ExcelProperty(value = "腐蚀裕量")
    String corrosionMargin;

    @ExcelProperty(value = "设计压力（管程）")
    String pressurePipe;

    @ExcelProperty(value = "单瓶容积")
    String singleBottleVolume;

    @ExcelProperty(value = "工作压力")
    String workingPressure;

    @ExcelProperty(value = "耐压试验压力（管路）")
    String glPressure;

    @ExcelProperty(value = "型号")
    String modelNumber;

    @ExcelProperty(value = "工作温度")
    String workTemperature;

    @ExcelProperty(value = "厚度（封头）")
    String fixedHead;

    @ExcelProperty(value = "耐压试验种类")
    String withstandVoltage;

    @ExcelProperty(value = "厚度（筒体）")
    String thicknessCylinder;

    @ExcelProperty(value = "介质（夹套）")
    String mediumJacket;


    @ExcelProperty(value = "滑索长度")
    String slideLength;

    @ExcelProperty(value = "运行速度")
    String runningSpeed1;

    @ExcelProperty(value = "运行高度")
    String operatingHeight;

    @ExcelProperty(value = "轨道高度")
    String trackHeight;

    @ExcelProperty(value = "回转速度")
    String slewingSpeed;

    @ExcelProperty(value = "回转直径")
    String rotaryDiameter;

    @ExcelProperty(value = "车辆数量")
    String numberOfVehicles;

    @ExcelProperty(value = "单侧摆角")
    String unilateralSwingAngle;

    @ExcelProperty(value = "承载人数")
    String numberOfPassengers;

    @ExcelProperty(value = "倾角")
    String dip;

    @ExcelProperty(value = "设备高度")
    String equipmentHeight;

    @ExcelProperty(value = "高差")
    String altitudeDifference;

    @ExcelProperty(value = "主电机型式")
    String mainMotorModel;

    @ExcelProperty(value = "斜长")

    String obliqueLength;

    @ExcelProperty(value = "支架数据")
    String supportsCount;

    @ExcelProperty(value = "平距")
    String horizontalDistance;

    @ExcelProperty(value = "张紧油压（重锤重量）")
    String oilPressureHeavyHammer;

    @ExcelProperty(value = "速度")
    String speed;

    @ExcelProperty(value = "主电机功率")
    String mainMotorPower;

    @ExcelProperty(value = "运载工具数量和类型")
    String numberAndTypeOfVehicles;

    @ExcelProperty(value = "运量")
    String freightVolume;

    @ExcelProperty(value = "索距")
    String cablePitch;

    @ExcelProperty(value = "运载索")
    @DictCode2DictName(type = "YZS", typeHandler = "cbDataDictTypeHandler")
    String carrierLine;

    @ExcelProperty(value = "承载索")
    String bearingCable;
}
