package com.yeejoin.amos.boot.module.jyjc.api.enums;

import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */

@AllArgsConstructor
@Getter
public enum ResultTypeEnum {
    /**
     * 集成方式
     */
    INPUT("手工录入", "input"),
    INTEGRATED("系统对接", "integrated"),
    USEUNITENTRY("使用单位录入", "useUnitEntry");

    private final String name;
    private final String code;

    private static final Map<String, String> CODE_NAME_MAP;

    static {
        CODE_NAME_MAP = Arrays.stream(ResultTypeEnum.values())
                .collect(Collectors.toMap(ResultTypeEnum::getCode, ResultTypeEnum::getName));
    }

    public static List<JSONObject> All() {
        return Arrays.stream(ResultTypeEnum.values())
                .map(item -> new JSONObject()
                        .fluentPut("code", item.getCode())
                        .fluentPut("name", item.getName()))
                .collect(Collectors.toList());
    }

    public static String getNameByCode(String code) {
        return CODE_NAME_MAP.getOrDefault(code, "");
    }
}
