package com.yeejoin.amos.boot.module.tcm.api.customer;

import com.yeejoin.amos.boot.module.tcm.api.dto.UserImportDto;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerEquipTypeValidator implements ConstraintValidator<CustomerEquipTypeCheck, UserImportDto> {


    /**
     * 需要填写设备类型的单位类型（字符串汉字数据库如此）及人员类型
     */
    private static final Map<String, List<String>> NEED_EQUIP_TYPE_UNIT_TYPE = new HashMap<>();

    static {
        // ("安全总监", "6547");
        // ("安全员", "6549");
        // ("质量安全总监", "6550");
        // ("质量安全员", "6551");
        NEED_EQUIP_TYPE_UNIT_TYPE.put("使用单位", Arrays.asList("6547", "6549"));
        NEED_EQUIP_TYPE_UNIT_TYPE.put("安装改造维修单位", Arrays.asList("6550", "6551"));
    }

    @Override
    public boolean isValid(UserImportDto userImportDto, ConstraintValidatorContext context) {
        if (NEED_EQUIP_TYPE_UNIT_TYPE.containsKey(userImportDto.getUnitType())) {
            List<String> postTypes = NEED_EQUIP_TYPE_UNIT_TYPE.get(userImportDto.getUnitType());
            // 单位类型是指定的且设备类型未空时校验不通过
            return !postTypes.contains(userImportDto.getPost()) || !StringUtils.isEmpty(userImportDto.getEquipType());
        } else {
            return true;
        }
    }
}
