package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 安全追溯-制造信息
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IdxBizJgFactoryInfoDto", description = "安全追溯-制造信息")
public class IdxBizJgFactoryInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @TableField("RECORD")
    private String record;


    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "制造单位统一社会信用代码")
    @TableField("PRODUCE_UNIT_CREDIT_CODE")
    private String produceUnitCreditCode;

    @ApiModelProperty(value = "制造单位名称")
    @TableField("PRODUCE_UNIT_NAME")
    private String produceUnitName;

    @ApiModelProperty(value = "制造许可编号")
    @TableField("PRODUCE_LICENSE_NUM")
    private String produceLicenseNum;

    @ApiModelProperty(value = "出厂编号")
    @TableField("FACTORY_NUM")
    private String factoryNum;

    @ApiModelProperty(value = "制造日期")
    @TableField("PRODUCE_DATE")
    private Date produceDate;

    @ApiModelProperty(value = "是否进口")
    @TableField("IMPORTED")
    private String imported;

    @ApiModelProperty(value = "制造国")
    @TableField("PRODUCE_COUNTRY")
    private String produceCountry;

    @ApiModelProperty(value = "制造标准")
    @TableField("FACTORY_STANDARD")
    private String factoryStandard;

    @ApiModelProperty(value = "产品质量合格证明")
    @TableField("PRODUCT_QUALITY_YIELD_PROVE")
    private String productQualityYieldProve;

    @ApiModelProperty(value = "安装及使用维护保养说明")
    @TableField("INS_USE_MAINTAIN_EXPLAIN")
    private String insUseMaintainExplain;

    @ApiModelProperty(value = "监督检验证书")
    @TableField("SUPERVISION_AGENCY_CREDENTIAL")
    private String supervisionAgencyCredential;

    @ApiModelProperty(value = "型式试验证书")
    @TableField("TYPE_TEST_CREDENTIAL")
    private String typeTestCredential;

    @ApiModelProperty(value = "资料是否完整齐全：1-齐全；2-不齐全【历史无证设备需要】")
    private String factoryIsComplete;
}
